package mobile;

import com.sun.util.logging.Level;

import java.sql.Date;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.GenericTypeBeanSerializationHelper;
import oracle.adfmf.framework.exception.AdfInvocationException;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class WeatherBean {
    public static WeatherInformation wi;
    public static CityInformation ci;

    private String zip = "94551";
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public WeatherBean() {
        wi = new WeatherInformation();
        ci = new CityInformation();
        ci.setWeatherInfo(wi);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    /**
     * This method is called from the action attribute of the Weather Info listItem on the home screen
     * We use the action so that we can choose whether to navigate based on an error being returned.
     **/ 
    public String callWeatherInfo() {
        String ret = "";
        // We only navigate to the WeatherInfo results if the retreiveWeatherInfo succeeds
        if (wi.retreiveWeatherInfo()) {
            ret = "weatherinfo";
        }
        return ret;
    }

    /**
     * This method is called from the action attribute of the search commandButton on the forecaseByZip screen
     * We use the action so that we can choose whether to navigate based on an error being returned.
     **/ 
    public String callForecast() {
        String ret = "";
        // We only navigate to the forecastResults if the retrieveForecast succeeds
        if (ci.retrieveForecast(zip)) {
            ret = "results";
        }
        return ret;
    }

    public void setZip(String zip) {
        String oldZip = this.zip;
        this.zip = zip;
        propertyChangeSupport.firePropertyChange("zip", oldZip, zip);
    }

    public String getZip() {
        return zip;
    }
}
