package mobile;

import com.sun.util.logging.Level;

import java.sql.Date;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class Forecast {
    public static WeatherInformation weatherInfo = null;
    private Date date;
    private Short weatherID;
    private String desciption = "";
    private String daytimeHigh = "";
    private String morningLow = "";
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Forecast() {
        super();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setDate(Date date) {
        Date oldDate = this.date;
        this.date = date;
        propertyChangeSupport.firePropertyChange("date", oldDate, date);
    }

    public Date getDate() {
        return date;
    }

    public void setWeatherID(Short weatherID) {
        Short oldWeatherID = this.weatherID;
        this.weatherID = weatherID;
        propertyChangeSupport.firePropertyChange("weatherID", oldWeatherID, weatherID);
    }

    public Short getWeatherID() {
        return weatherID;
    }

    public void setDesciption(String desciption) {
        String oldDesciption = this.desciption;
        this.desciption = desciption;
        propertyChangeSupport.firePropertyChange("desciption", oldDesciption, desciption);
    }

    public String getDescription() {
        return desciption;
    }

    public void setDaytimeHigh(String daytimeHigh) {
        String oldDaytimeHigh = this.daytimeHigh;
        this.daytimeHigh = daytimeHigh;
        propertyChangeSupport.firePropertyChange("daytimeHigh", oldDaytimeHigh, daytimeHigh);
    }

    public String getDaytimeHigh() {
        return daytimeHigh;
    }

    public void setMorningLow(String morningLow) {
        String oldMorningLow = this.morningLow;
        this.morningLow = morningLow;
        propertyChangeSupport.firePropertyChange("morningLow", oldMorningLow, morningLow);
    }

    public String getMorningLow() {
        return morningLow;
    }
    
    public String getImage() {
        String ret = "";
        if( weatherInfo != null ) {
            ret = weatherInfo.getWeatherImage(getWeatherID());
        }
        return ret;
    }
}
