package mobile;

import application.LifeCycleListenerImpl;

import com.sun.util.logging.Level;

import javax.el.MethodExpression;

import javax.el.ValueExpression;

import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.amx.event.SelectionEvent;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class HRBean {
    private String detailtab = "profile";
    private String metrictab = "salary";
    private String orgtab = "byname";
    private boolean searchOn = false;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public HRBean() {
    }

    public void DeleteHandler(ActionEvent actionEvent) {
        try {
        ValueExpression ve1 =
            AdfmfJavaUtilities.getValueExpression("#{bindings.currentEmp.inputValue}", Integer.class);
        Integer currentEmp = (Integer)ve1.getValue(AdfmfJavaUtilities.getAdfELContext());

        ValueExpression ve2 =
            AdfmfJavaUtilities.getValueExpression("#{bindings.deleteEmpNo.inputValue}", Integer.class);
        Integer deleteNo = (Integer)ve2.getValue(AdfmfJavaUtilities.getAdfELContext());

        MethodExpression me1 =
            AdfmfJavaUtilities.getMethodExpression("#{bindings.DeleteEmployee.execute}", Object.class,
                                                   new Class[] { });
        me1.invoke(AdfmfJavaUtilities.getAdfELContext(), new Object[] { });

        if (currentEmp.intValue() == deleteNo.intValue()) {
            MethodExpression me2 =
                AdfmfJavaUtilities.getMethodExpression("#{bindings.Previous.execute}", Object.class, new Class[] { });
            me2.invoke(AdfmfJavaUtilities.getAdfELContext(), new Object[] { });
        }
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "savePictureToDB",
                      "##############Exception:  " + e.getMessage());
        }

    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setDetailtab(String detailtab) {
        String oldDetailtab = this.detailtab;
        this.detailtab = detailtab;
        propertyChangeSupport.firePropertyChange("detailtab", oldDetailtab, detailtab);
    }

    public String getDetailtab() {
        return detailtab;
    }

    public void setMetrictab(String metrictab) {
        String oldMetrictab = this.metrictab;
        this.metrictab = metrictab;
        propertyChangeSupport.firePropertyChange("metrictab", oldMetrictab, metrictab);
    }

    public String getMetrictab() {
        return metrictab;
    }

    public void setOrgtab(String orgtab) {
        String oldOrgtab = this.orgtab;
        this.orgtab = orgtab;
        propertyChangeSupport.firePropertyChange("orgtab", oldOrgtab, orgtab);
    }

    public String getOrgtab() {
        return orgtab;
    }

    public void setSearchOn(boolean searchOn) {
        boolean oldSearchOn = this.searchOn;
        this.searchOn = searchOn;
        propertyChangeSupport.firePropertyChange("searchOn", oldSearchOn, searchOn);
    }

    public boolean isSearchOn() {
        return searchOn;
    }

    public void orgMapSelectionHandler(SelectionEvent selectionEvent) {
        MethodExpression me = AdfmfJavaUtilities.getMethodExpression("#{bindings.setCurrentRowWithKeyValue.execute}", Object.class, new Class[] {}); 
        me.invoke(AdfmfJavaUtilities.getAdfELContext(), new Object[] {});
    }

    public void exportContactHandler(ActionEvent actionEvent) {
        // Add event code here...
    }
}
