package HR;

import application.DBConnectionFactory;

import com.sun.util.logging.Level;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class LocationList {
    private static List s_locations = null;

    public LocationList() {
        if (s_locations == null) {
            s_locations = new ArrayList();
        }
        Execute();
    }

    public void Execute() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, LocationList.class, "Execute",
                  "!!!!!!!!!!!!!!!!!In LOCATION Execute!!!!!!!!!!!!!!!!!!!!!!!!!");
        try {
            Connection conn = DBConnectionFactory.getConnection();
            s_locations.clear();
            conn.setAutoCommit(false);
            PreparedStatement stat = conn.prepareStatement("SELECT * from LOCATIONS");
            ResultSet rs = stat.executeQuery();
            Trace.log(Utility.ApplicationLogger, Level.INFO, LocationList.class, "Execute",
                      "!!!!!!!!!!!!!!!!!Query Executed!!!!!!!!!!!!!!!!!!!!!!!!!");
            while (rs.next()) {
                int id = rs.getInt("LOCATION_ID");
                String address = rs.getString("STREET_ADDRESS");
                String postal = rs.getString("POSTAL_CODE");
                String city = rs.getString("CITY");
                String state = rs.getString("STATE_PROVINCE");
                String countryId = rs.getString("COUNTRY_ID");
                Location l = new Location(id, address, postal, city, state, countryId);
                s_locations.add(l);
            }
            rs.close();
        } catch (SQLException e) {
            System.err.println(e.getMessage());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Location getLocationById(int locationId) {
        Location l = null;
        int count = s_locations.size();
        for (int x = 0; x < count; x++) {
            l = (Location)s_locations.get(x);
            if (l.getId() == locationId) {
                break;
            }
        }
        return l;
    }

    public Location[] getLocations() {
        Location l[] = null;

        l = (Location[])s_locations.toArray(new Location[s_locations.size()]);

        return l;
    }
}
