package HR;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class Location {
    protected static CountryList countries = new CountryList();
    protected transient Country country = null;
    protected int id;
    protected String address;
    protected String postal;
    protected String city;
    protected String state;
    protected String countryId;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Location() {
        super();
    }
    
    public Location(int id, String address, String postal, String city, String state, String countryId) {
        setId(id);
        setAddress(address);
        setPostal(postal);
        setCity(city);
        setState(state);
        setCountryId(countryId);
    }

    public void setId(int id) {
        int oldId = this.id;
        this.id = id;
        propertyChangeSupport.firePropertyChange("id", oldId, id);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public int getId() {
        return id;
    }

    public void setAddress(String address) {
        String oldAddress = this.address;
        this.address = address;
        propertyChangeSupport.firePropertyChange("address", oldAddress, address);
    }

    public String getAddress() {
        return address;
    }

    public void setPostal(String postal) {
        String oldPostal = this.postal;
        this.postal = postal;
        propertyChangeSupport.firePropertyChange("postal", oldPostal, postal);
    }

    public String getPostal() {
        return postal;
    }

    public void setCity(String city) {
        String oldCity = this.city;
        this.city = city;
        propertyChangeSupport.firePropertyChange("city", oldCity, city);
    }

    public String getCity() {
        return city;
    }

    public void setState(String state) {
        String oldState = this.state;
        this.state = state;
        propertyChangeSupport.firePropertyChange("state", oldState, state);
    }

    public String getState() {
        return state;
    }

    public void setCountryId(String countryId) {
        String oldCountryId = this.countryId;
        this.countryId = countryId;
        propertyChangeSupport.firePropertyChange("countryId", oldCountryId, countryId);
    }

    public String getCountryId() {
        return countryId;
    }
    
    public Country getCountry() {
        if( country == null) {
            country = countries.getCountryById(getCountryId());
        }
        return country;
        
    }
}
