package HR;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class Job {
    protected String jobId;
    protected String title;
    protected int minSalary;
    protected int maxSalary;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Job() {
        super();
    }
    
    public Job( String jobId, String title, int minSalary, int maxSalary) {
        setJobId(jobId);
        setTitle(title);
        setMinSalary(minSalary);
        setMaxSalary(maxSalary);
    }

    public void setJobId(String jobId) {
        String oldJobId = this.jobId;
        this.jobId = jobId;
        propertyChangeSupport.firePropertyChange("jobId", oldJobId, jobId);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getJobId() {
        return jobId;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        propertyChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    public String getTitle() {
        return title;
    }

    public void setMinSalary(int minSalary) {
        int oldMinSalary = this.minSalary;
        this.minSalary = minSalary;
        propertyChangeSupport.firePropertyChange("minSalary", oldMinSalary, minSalary);
    }

    public int getMinSalary() {
        return minSalary;
    }

    public void setMaxSalary(int maxSalary) {
        int oldMaxSalary = this.maxSalary;
        this.maxSalary = maxSalary;
        propertyChangeSupport.firePropertyChange("maxSalary", oldMaxSalary, maxSalary);
    }

    public int getMaxSalary() {
        return maxSalary;
    }
}
