package HR;

import application.DBConnectionFactory;

import application.LifeCycleListenerImpl;

import com.sun.util.logging.Level;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import java.util.ArrayList;
import java.util.List;

import oracle.adf.model.datacontrols.device.DeviceManager;

import oracle.adf.model.datacontrols.device.DeviceManagerFactory;

import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.java.beans.ProviderChangeListener;
import oracle.adfmf.java.beans.ProviderChangeSupport;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;


public class EmployeeList {
    private static List s_employees = null;
    private Employee editEmployee = new Employee();
    private transient ProviderChangeSupport providerChangeSupport = new ProviderChangeSupport(this);
    private boolean newEmp = false;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int employeeCount = -1;
    private int deleteEmpNo = 0;
    private int currentEmp = 0;
    private String filter = "";
    private String apppath = AdfmfJavaUtilities.getDirectoryPathRoot(AdfmfJavaUtilities.ApplicationDirectory);
    private static final String NOPIC = "/images/missingEmployee_120.png";
    private static final int ALLRECORDS = -1;
    private static final String SORTLNAME = "LAST_NAME";
    private static final String SORTIDDESC = "EMPLOYEE_ID DESC";
    private static final String SORTID = "EMPLOYEE_ID";

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.addProviderChangeListener(l);
    }

    public void removeProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.removeProviderChangeListener(l);
    }

    public EmployeeList() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "EmployeeList",
                  "!!!!!!!!!!!!!!!!!In the EmployeeList constructor!!!!!!!!!!!!!!!!!!!!!!!!!");
        if (s_employees == null) {
            s_employees = new ArrayList();
            Execute();
        }
    }

    public Employee[] getEmployees() {
        Employee e[] = null;

        e = (Employee[])s_employees.toArray(new Employee[s_employees.size()]);

        return e;
    }

    public void setEmployeeCount(int employeeCount) {
        int oldEmployeeCount = this.employeeCount;
        this.employeeCount = employeeCount;
        propertyChangeSupport.firePropertyChange("employeeCount", oldEmployeeCount, employeeCount);
    }

    public int getEmployeeCount() {
        return s_employees.size();
    }

    public void setFilter(String filter) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "setFilter",
                  "##############Filter = " + filter);
        String oldFilter = this.filter;
        this.filter = filter;
        propertyChangeSupport.firePropertyChange("filter", oldFilter, filter);
    }

    public String getFilter() {
        return filter;
    }

    public void setCurrentEmp(int currentEmp) {
        int oldCurrentEmp = this.currentEmp;
        this.currentEmp = currentEmp;
        propertyChangeSupport.firePropertyChange("currentEmp", oldCurrentEmp, currentEmp);
    }

    public int getCurrentEmp() {
        return currentEmp;
    }

    public void setNewEmp(boolean newEmp) {
        this.newEmp = newEmp;
    }

    public boolean getNewEmp() {
        return newEmp;
    }

    public void setEditEmployee(Employee editEmployee) {
        this.editEmployee.copy(editEmployee);
    }

    public Employee getEditEmployee() {
        return editEmployee;
    }

    public void setDeleteEmpNo(int deleteEmpNo) {
        int oldDeleteEmpNo = this.deleteEmpNo;
        this.deleteEmpNo = deleteEmpNo;
        propertyChangeSupport.firePropertyChange("deleteEmpNo", oldDeleteEmpNo, deleteEmpNo);
    }

    public int getDeleteEmpNo() {
        return deleteEmpNo;
    }


    ///////////////////////////////////
    //      Utility Methods - Begin
    ///////////////////////////////////

    public Employee getEmployeeById(int empId) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "getEmployeeById",
                  "##############Inside getEmployeeById");
        Employee e = null;

        ArrayList tempEmps = new ArrayList();
        tempEmps = selectEmpsFromDB("EMPLOYEE_ID = " + empId, SORTLNAME, 1);
        if (tempEmps.size() > 0) {
            e = (Employee)tempEmps.get(0);
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "getEmployeeById",
                  "##############getEmployeeById completed");
        return e;
    }

    public ArrayList getEmployeeReports(int empId) {
        ArrayList reports = null;
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "getEmployeeReports",
                  "##############Inside getEmployeeReports");

        reports = selectEmpsFromDB("MANAGER_ID = " + empId, SORTLNAME, ALLRECORDS);
        if(reports == null) {
            reports = new ArrayList();
        }
        
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "getEmployeeReports",
                  "##############getEmployeeReports completed");

        return reports;
    }

    public int getEmployeeReportCount(int empId) {
        int reportCount = 0;

        ArrayList reports = getEmployeeReports(empId);
        reportCount = reports.size();
        
        return reportCount;
    }

    private boolean UpdateReportingToMgr(Employee emp) {
        boolean ret = true;
        Employee[] reports = emp.getReports();
        int mgrID = emp.getManagerId();
        int count = reports.length;
        for (int x = 0; x < count; x++) {
            reports[x].setManagerId(mgrID);
            ret = UpdateEmpToDB(reports[x]);
            if (!ret) {
                break;
            }
        }
        return ret;
    }


    public void calculateMinMaxValues(Employee currEmp) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "calculateMinMaxValues",
                  "##############Inside calculateMinMaxValues");

        ArrayList empsInOrg = new ArrayList();
        empsInOrg = selectEmpsFromDB("DEPARTMENT_ID = " + currEmp.getDepartmentId(), SORTLNAME, ALLRECORDS);

        int count = empsInOrg.size();
        for (int x = 0; x < count; x++) {
            Employee e = (Employee)empsInOrg.get(x);
            double salary = e.getSalary();
            if (e.getDepartmentId() == currEmp.getDepartmentId()) {
                if (salary > currEmp.maxOrgSalary) {
                    currEmp.maxOrgSalary = salary;
                }
                if (salary < currEmp.minOrgSalary) {
                    currEmp.minOrgSalary = salary;
                }
            }
        }
        if (currEmp.maxOrgSalary == currEmp.minOrgSalary) {
            currEmp.minOrgSalary = 0;
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "calculateMinMaxValues",
                  "##############calculateMinMaxValues completed");
    }
    ///////////////////////////////////
    //      Utility Methods - End
    ///////////////////////////////////


    ///////////////////////////////////
    //        DC Methods - Begin
    ///////////////////////////////////

    public void Execute() {
        s_employees.clear();
        String filter = getFilter();
        String whereClause = "";
        if (filter.length() > 0) {
            whereClause += "FIRST_NAME LIKE '%" + filter + "%' OR LAST_NAME LIKE '%" + filter + "%'";
        }
        s_employees = selectEmpsFromDB(whereClause, SORTLNAME, ALLRECORDS);

        providerChangeSupport.fireProviderRefresh("employees");
    }

    public void AddEmployee() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "AddEmployee",
                  "##############Adding Employee");
        int maxId = 0;
        ArrayList lastEmp = new ArrayList();
        lastEmp = selectEmpsFromDB("", SORTIDDESC, 1);
        if (lastEmp.size() > 0) {
            Employee e = (Employee)lastEmp.get(0);
            maxId = e.getId();
        }

        int minId = 0;
        ArrayList firstEmp = new ArrayList();
        firstEmp = selectEmpsFromDB("", SORTID, 1);
        if (firstEmp.size() > 0) {
            Employee e = (Employee)firstEmp.get(0);
            minId = e.getId();
        }
        setEditEmployee(new Employee(maxId + 1, "", "", "", "", new Date(System.currentTimeMillis()), "AD_ASST", 0, 0,
                                     minId, 10, NOPIC, false));
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "AddEmployee",
                  "##############Adding completed");
    }

    public void EditEmployee(int id) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "EditEmployee",
                  "##############Editing Employee");
        int count = getEmployeeCount();
        for (int x = 0; x < count; x++) {
            Employee e = (Employee)s_employees.get(x);
            if (e.id == id) {
                Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "EditEmployee",
                          "##############Found Employee to edit");
                setEditEmployee(e);
                break;
            }
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "EditEmployee",
                  "##############Editing completed");
    }

    public void SaveEmployee() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "SaveEmployee",
                  "##############Saving Employee");
        if (newEmp) {
            if (AddEmpToDB()) {
                Employee newEmployee = new Employee(editEmployee);
                Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "SaveEmployee",
                          "##############Inserting Employee");
                s_employees.add(0, newEmployee);
                providerChangeSupport.fireProviderCreate("employees", newEmployee.getKey(), newEmployee);
                Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "SaveEmployee",
                          "##############Employee inserted");
            }
        } else {
            int count = getEmployeeCount();
            for (int x = 0; x < count; x++) {
                Employee e = (Employee)s_employees.get(x);
                if (e.id == editEmployee.id) {
                    Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "SaveEmployee",
                              "##############Found Employee to update");
                    if (UpdateEmpToDB(editEmployee)) {
                        e.copy(editEmployee);
                        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "SaveEmployee",
                                  "##############Employee" + e.getFirstName() + " " + e.getLastName() + " Updated");
                        setEditEmployee(e);
                        break;
                    }
                }
            }
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "SaveEmployee",
                  "##############Saving completed");
    }

    public void DeleteEmployee(int id) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "DeleteEmployee",
                  "##############Inside DeleteEmployee");
        int count = getEmployeeCount();
        for (int x = 0; x < count; x++) {
            Employee e = (Employee)s_employees.get(x);
            if (e.id == id) {
                Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "DeleteEmployee",
                          "##############Found Employee to delete");
                if (UpdateReportingToMgr(e)) {
                    if (DeleteEmpFromDB(id)) {
                        setDeleteEmpNo(0);
                        s_employees.remove(x);
                        providerChangeSupport.fireProviderDelete("employees", e.getKey());

                        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "DeleteEmployee",
                                  "##############Employee deleted");
                        break;
                    }
                }
            }
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "DeleteEmployee",
                  "##############DeleteEmployee completed");
    }

    public void fetchPicture() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "savePicture",
                  "##############Inside savePicture");

        DeviceManager dm = DeviceManagerFactory.getDeviceManager();
        int source = dm.CAMERA_SOURCETYPE_CAMERA;

        // If we're in the simulator on iOS, then we'll use the photolibrary
        if (dm.getName().indexOf("Simulator") != -1) {
            source = dm.CAMERA_SOURCETYPE_PHOTOLIBRARY;
        }

        String inFile =
            dm.getPicture(25, dm.CAMERA_DESTINATIONTYPE_FILE_URI, source, false, dm.CAMERA_ENCODINGTYPE_PNG, 56, 55);

        if (inFile != null && inFile.length() > 0) {
            editEmployee.setPic(inFile);
        }
    }


    public void clearPicture() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "clearPicture",
                  "##############Inside clearPicture");

        String picpath = apppath + "/" + editEmployee.getId() + ".png";
        File f = new File(picpath);
        if (f.exists()) {
            f.delete();
        }

        editEmployee.setPic(NOPIC);
    }

    // This method iterates though the collection and turns off any delete buttons except the row swiped

    public void ShowDeleteButton(int id) {
        Employee e = null;
        int count = getEmployeeCount();
        for (int x = 0; x < count; x++) {
            e = (Employee)s_employees.get(x);
            if (e.getId() == id) {
                e.setShowDelete(true);
            } else if (e.isShowDelete()) {
                e.setShowDelete(false);
            }
        }
    }

    // This method clears all delete buttons.  We do this when a delete button exists but someone taps on another row

    public void ClearDeleteButton() {
        Employee e = null;
        int count = getEmployeeCount();
        for (int x = 0; x < count; x++) {
            e = (Employee)s_employees.get(x);
            if (e.isShowDelete()) {
                e.setShowDelete(false);
            }
        }
    }
    
    public void exportContact() {
        AdfException e = new AdfException("Function Not Implemented",AdfException.WARNING);
        throw e;
    }

    ///////////////////////////////////
    //        DC Methods - End
    ///////////////////////////////////


    ///////////////////////////////////
    //    Database Methods - Begin
    ///////////////////////////////////

    private ArrayList selectEmpsFromDB(String filter, String order, int maxRecords) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "selectEmpsFromDB",
                  "##############Inside selectEmpsFromDB");
        ArrayList empList = new ArrayList();

        try {
            Connection conn = DBConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            String select = "SELECT * FROM EMPLOYEES";
            if (filter.length() > 0) {
                select += " WHERE " + filter;
            }
            if (order.length() > 0) {
                select += " ORDER BY " + order;
            }
            if (maxRecords != ALLRECORDS) {
                select += " lIMIT " + maxRecords;
            }
            Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "selectEmpsFromDB",
                      "##############" + select);
            PreparedStatement pStmt = conn.prepareStatement(select);
            ResultSet rs = pStmt.executeQuery();
            Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "selectEmpsFromDB",
                      "!!!!!!!!!!!!!!!!!Query Executed!!!!!!!!!!!!!!!!!!!!!!!!!");
            while (rs.next()) {
                int id = rs.getInt("EMPLOYEE_ID");
                String first = rs.getString("FIRST_NAME");
                String last = rs.getString("LAST_NAME");
                String email = rs.getString("EMAIL");
                String phone = rs.getString("PHONE_NUMBER");
                Date hireDate = rs.getDate("HIRE_DATE");
                if (hireDate == null) {
                    hireDate = new Date(0);
                }
                
                
                String jobId = rs.getString("JOB_ID");
                double salary = getDouble(rs, "SALARY");
                double commPct = getDouble(rs, "COMMISSION_PCT");
                int mgrId = rs.getInt("MANAGER_ID");
                int deptId = rs.getInt("DEPARTMENT_ID");
                String emppic = NOPIC;

                String picpath = apppath + "/" + id + ".png";
                File f = new File(picpath);
                if (f != null && f.exists()) {
                    emppic = "file://" + picpath + "?" + System.currentTimeMillis();
                } else {
                    byte[] b = rs.getBytes("PIC");
                    if (b != null && b.length > 0) {
                        FileOutputStream out = new FileOutputStream(picpath);
                        out.write(b);
                        out.close();
                        emppic = "file://" + picpath + "?" + System.currentTimeMillis();
                    }
                }
                
                Employee e =
                    new Employee(id, first, last, email, phone, hireDate, jobId, salary, commPct, mgrId, deptId, emppic,
                                 false);
                empList.add(e);
            }
            rs.close();
            Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "selectEmpsFromDB",
                      "##############selectEmpsFromDB completed");
        } catch (SQLException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "selectEmpsFromDB",
                      "##############Exception:  " + e.getMessage());
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "selectEmpsFromDB",
                      "##############Exception:  " + e.getMessage());
        }
        
        return empList;
    }

    public boolean AddEmpToDB() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "AddEmpToDB",
                  "##############Inside AddEmpToDB");
        boolean ret = false;

        try {
            Connection conn = DBConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            String insertSQL =
                "Insert into EMPLOYEES (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (?,?,?,?,?,?,?,?,?,?,?)";

            PreparedStatement pStmt = conn.prepareStatement(insertSQL);
            pStmt.setInt(1, editEmployee.getId());
            pStmt.setString(2, editEmployee.getFirstName());
            pStmt.setString(3, editEmployee.getLastName());
            pStmt.setString(4, editEmployee.getEmail());
            pStmt.setString(5, editEmployee.getPhoneNumber());
            pStmt.setDate(6, editEmployee.getHireDate());
            pStmt.setString(7, editEmployee.getJobId());
            pStmt.setDouble(8, editEmployee.getSalary());
            pStmt.setDouble(9, editEmployee.getCommissionPct());
            pStmt.setInt(10, editEmployee.getManagerId());
            pStmt.setInt(11, editEmployee.getDepartmentId());
            pStmt.execute();
            conn.commit();
            ret = true;
            savePictureToDB();
            Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "AddEmpToDB",
                      "##############AddEmpToDB completed");
        } catch (SQLException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "AddEmpToDB",
                      "##############Exception:  " + e.getMessage());
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "AddEmpToDB",
                      "##############Exception:  " + e.getMessage());
        }

        return ret;
    }

    public boolean UpdateEmpToDB(Employee emp) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "UpdateEmpToDB",
                  "##############Inside UpdateEmpToDB");
        boolean ret = false;

        try {
            Connection conn = DBConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            String updateSQL =
                "UPDATE EMPLOYEES SET FIRST_NAME=?,LAST_NAME=?,EMAIL=?,PHONE_NUMBER=?,HIRE_DATE=?,JOB_ID=?,SALARY=?,COMMISSION_PCT=?,MANAGER_ID=?,DEPARTMENT_ID=? WHERE EMPLOYEE_ID=?";

            PreparedStatement pStmt = conn.prepareStatement(updateSQL);
            pStmt.setString(1, emp.getFirstName());
            pStmt.setString(2, emp.getLastName());
            pStmt.setString(3, emp.getEmail());
            pStmt.setString(4, emp.getPhoneNumber());
            pStmt.setDate(5, emp.getHireDate());
            pStmt.setString(6, emp.getJobId());
            pStmt.setDouble(7, emp.getSalary());
            pStmt.setDouble(8, emp.getCommissionPct());
            pStmt.setInt(9, emp.getManagerId());
            pStmt.setInt(10, emp.getDepartmentId());
            pStmt.setInt(11, emp.getId());
            pStmt.execute();
            conn.commit();
            ret = true;
            savePictureToDB();
            Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "UpdateEmpToDB",
                      "##############UpdateEmpToDB completed");
        } catch (SQLException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "UpdateEmpToDB",
                      "##############Exception:  " + e.getMessage());
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "UpdateEmpToDB",
                      "##############Exception:  " + e.getMessage());
        }

        return ret;
    }

    public boolean DeleteEmpFromDB(int id) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "DeleteEmpFromDB",
                  "##############Inside DeleteEmpFromDB");
        boolean ret = false;

        try {
            Connection conn = DBConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            String updateSQL = "DELETE FROM EMPLOYEES WHERE EMPLOYEE_ID=?";

            PreparedStatement pStmt = conn.prepareStatement(updateSQL);
            pStmt.setInt(1, id);
            pStmt.execute();
            conn.commit();
            ret = true;
            Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "DeleteEmpFromDB",
                      "##############DeleteEmpFromDB completed");
        } catch (SQLException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "DeleteEmpFromDB",
                      "##############Exception:  " + e.getMessage());
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "DeleteEmpFromDB",
                      "##############Exception:  " + e.getMessage());
        }

        return ret;
    }

    public void savePictureToDB() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, EmployeeList.class, "savePicture",
                  "##############Inside savePicture");
        try {

            Connection conn;
            conn = DBConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            String sql = "UPDATE EMPLOYEES SET PIC=? WHERE EMPLOYEE_ID=?";
            PreparedStatement pStmt = conn.prepareStatement(sql);

            String inFile = editEmployee.getPic();
            if (inFile.compareTo(NOPIC) == 0) {
                pStmt.setNull(1, Types.NULL);
            } else {
                URL u = new URL(inFile);
                FileInputStream in = new FileInputStream(u.getPath());
                byte[] b = new byte[in.available()];
                in.read(b);
                pStmt.setBytes(1, b);
                in.close();
            }
            pStmt.setInt(2, editEmployee.getId());
            pStmt.execute();
            conn.commit();

        } catch (MalformedURLException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "savePictureToDB",
                      "##############Exception:  " + e.getMessage());
        } catch (IOException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "savePictureToDB",
                      "##############Exception:  " + e.getMessage());
        } catch (SQLException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "savePictureToDB",
                      "##############Exception:  " + e.getMessage());
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "savePictureToDB",
                      "##############Exception:  " + e.getMessage());
        }
    }

    ///////////////////////////////////
    //    Database Methods - End
    ///////////////////////////////////
    private double getDouble(ResultSet rs, String column) throws SQLException {
        if(rs != null) {
            String temp = rs.getString(column);
            
            if(Utility.isNotEmpty(temp)) {
                return Double.parseDouble(temp);
            }
        }
        return 0.0d;
    }

}
