package HR;

import java.util.ArrayList;
import java.sql.Date;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.java.beans.ProviderChangeListener;
import oracle.adfmf.java.beans.ProviderChangeSupport;

public class Employee {
    protected static final String NOPIC = "/images/missingEmployee_120.png"; 
    protected static final double MAXSALARY = 99999;
    protected static final double MINSALARY = 0;
    protected static DepartmentList depts = new DepartmentList();
    protected static JobList jobs = new JobList();
    protected static EmployeeList emps = new EmployeeList();
    protected transient Employee manager = null;
    protected transient Job job = null;
    protected transient Department department = null;
    protected transient ArrayList reports = null;
    protected int id;
    protected String first;
    protected String last;
    protected String email;
    protected String phone;
    protected Date hireDate;
    protected String jobId;
    protected double salary;
    protected double commPct;
    protected int mgrId;
    protected int deptId;
    protected String pic = NOPIC;
    protected int reportCount = -1;
    protected boolean showDelete = false;
    protected double minOrgSalary = MAXSALARY;
    protected double maxOrgSalary = MINSALARY;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient ProviderChangeSupport providerChangeSupport = new ProviderChangeSupport(this);

    public Employee() {
    }
    
    public Employee( Employee newemp ) {
        setId(newemp.id);
        setFirstName(newemp.first);
        setLastName(newemp.last);
        setEmail(newemp.email);
        setPhoneNumber(newemp.phone);
        setHireDate(newemp.hireDate);
        setJobId(newemp.jobId);
        setSalary(newemp.salary);
        setCommissionPct(newemp.commPct);
        setManagerId(newemp.mgrId);
        setDepartmentId(newemp.deptId);
        setShowDelete(newemp.isShowDelete());
    }

    public Employee(int id, String first, String last, String email, String phone, Date hireDate, String jobId, double salary, double commPct, int mgrId, int deptId, String pic, boolean showDelete) {
        this.id = id;
        this.first = first;
        this.last = last;
        this.email = email;
        this.phone = phone;
        this.hireDate = hireDate;
        this.jobId = jobId;
        this.salary = salary;
        this.commPct = commPct;
        this.mgrId = mgrId;
        this.deptId = deptId;
        this.pic = pic;
        this.showDelete = showDelete;
    }

    public void copy( Employee newemp ) {
        setId(newemp.id);
        setFirstName(newemp.first);
        setLastName(newemp.last);
        setEmail(newemp.email);
        setPhoneNumber(newemp.phone);
        setHireDate(newemp.hireDate);
        setJobId(newemp.jobId);
        setSalary(newemp.salary);
        setCommissionPct(newemp.commPct);
        setManagerId(newemp.mgrId);
        setDepartmentId(newemp.deptId);
        setPic(newemp.pic);
        setShowDelete(newemp.showDelete);
        reports = emps.getEmployeeReports(newemp.id);
        providerChangeSupport.fireProviderRefresh("reports");
    }
 
    public String getKey() {
        Integer i = new Integer(id);
        return i.toString();        
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.addProviderChangeListener(l);
    }

    public void removeProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.removeProviderChangeListener(l);
    }

    public void setId(int id) {
        int oldId = this.id;
        this.id = id;
        propertyChangeSupport.firePropertyChange("id", oldId, id);
    }

    public int getId() {
        return id;
    }

    public void setFirstName(String first) {
        String oldFirst = this.first;
        this.first = first;
        propertyChangeSupport.firePropertyChange("first", oldFirst, first);
    }

    public String getFirstName() {
        return first;
    }

    public void setLastName(String last) {
        String oldLast = this.last;
        this.last = last;
        propertyChangeSupport.firePropertyChange("last", oldLast, last);
    }

    public String getLastName() {
        return last;
    }

    public void setPhoneNumber(String phone) {
        String oldPhone = this.phone;
        this.phone = phone;
        propertyChangeSupport.firePropertyChange("phone", oldPhone, phone);
    }

    public String getPhoneNumber() {
        return phone;
    }

    public void setSalary(double salary) {
        double oldSalary = this.salary;
        this.salary = salary;
        propertyChangeSupport.firePropertyChange("salary", oldSalary, salary);
    }

    public double getSalary() {
        return salary;
    }

    public void setEmail(String email) {
        String oldEmail = this.email;
        this.email = email;
        propertyChangeSupport.firePropertyChange("email", oldEmail, email);
    }

    public String getEmail() {
        return email;
    }

    public void setHireDate(Date hireDate) {
        Date oldHireDate = this.hireDate;
        this.hireDate = hireDate;
        propertyChangeSupport.firePropertyChange("hireDate", oldHireDate, hireDate);
    }

    public Date getHireDate() {
        return hireDate;
    }

    public void setJobId(String jobId) {
        String oldJobId = this.jobId;
        this.jobId = jobId;
        propertyChangeSupport.firePropertyChange("jobId", oldJobId, jobId);
    }

    public String getJobId() {
        return jobId;
    }

    public void setDepartmentId(int deptId) {
        int oldDeptId = this.deptId;
        this.deptId = deptId;
        propertyChangeSupport.firePropertyChange("deptId", oldDeptId, deptId);
    }

    public int getDepartmentId() {
        return deptId;
    }

    public void setManagerId(int mgrId) {
        manager = null;
        int oldMgrId = this.mgrId;
        this.mgrId = mgrId;
        propertyChangeSupport.firePropertyChange("mgrId", oldMgrId, mgrId);
    }

    public int getManagerId() {
        return mgrId;
    }

    public void setCommissionPct(double commPct) {
        double oldCommPct = this.commPct;
        this.commPct = commPct;
        propertyChangeSupport.firePropertyChange("commPct", oldCommPct, commPct);
    }

    public double getCommissionPct() {
        return commPct;
    }

    public Department getDepartment() {
        if( department == null) {
            department = depts.getDepartmentById(getDepartmentId());
        }
        return department;
    }
    
    public Job getJob() {
        if( job == null) {
            job = jobs.getJobById(getJobId());
        }
        return job;
    }

    public Employee getManager() {
        if( manager == null) {
            manager = emps.getEmployeeById(getManagerId());
        }
        return manager;
    }
    
    public Employee[] getReports() {
        if( reports == null ) {
            Employee[]  myReports = null;
            
            reports = emps.getEmployeeReports(getId());
            setReportCount(reports.size());
            
            myReports = (Employee[])reports.toArray(new Employee[reports.size()]);
            providerChangeSupport.fireProviderRefresh("reports");
            return  myReports;
        }
        else {
            return (Employee[])reports.toArray(new Employee[reports.size()]);
        }
        
    }

    public void setPic(String pic) {
        String oldPic = this.pic;
        this.pic = pic;
        propertyChangeSupport.firePropertyChange("pic", oldPic, pic);
    }

    public String getPic() {
        return pic;
    }


    public void setShowDelete(boolean showDelete) {
        boolean oldShowDelete = this.showDelete;
        this.showDelete = showDelete;
        propertyChangeSupport.firePropertyChange("showDelete", oldShowDelete, showDelete);
    }

    public boolean isShowDelete() {
        return showDelete;
    }

    public void setMinOrgSalary(double minOrgSalary) {
        double oldMinOrgSalary = this.minOrgSalary;
        this.minOrgSalary = minOrgSalary;
        propertyChangeSupport.firePropertyChange("minOrgSalary", oldMinOrgSalary, minOrgSalary);
    }

    public double getMinOrgSalary() {
        if( minOrgSalary == this.MAXSALARY ) {
            emps.calculateMinMaxValues(this);
        }
        return minOrgSalary;
    }

    public void setMaxOrgSalary(double maxOrgSalary) {
        double oldMaxOrgSalary = this.maxOrgSalary;
        this.maxOrgSalary = maxOrgSalary;
        propertyChangeSupport.firePropertyChange("maxOrgSalary", oldMaxOrgSalary, maxOrgSalary);
    }

    public double getMaxOrgSalary() {
        if( maxOrgSalary == this.MINSALARY ) {
            emps.calculateMinMaxValues(this);
        }
        return maxOrgSalary;
    }

    public void setReportCount(int reportCount) {
        int oldReportCount = this.reportCount;
        this.reportCount = reportCount;
        propertyChangeSupport.firePropertyChange("reportCount", oldReportCount, reportCount);
    }

    public int getReportCount() {
        if( reportCount == -1) {
            reportCount = emps.getEmployeeReportCount(getId());
        }
        return reportCount;
    }
}


