package HR;

import application.DBConnectionFactory;

import application.LifeCycleListenerImpl;

import com.sun.util.logging.Level;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class CountryList {
    private static List s_countries = null;

    public CountryList() {
        if (s_countries == null) {
            s_countries = new ArrayList();
        }
        Execute();
    }

    public void Execute() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, CountryList.class, "Execute",
                  "!!!!!!!!!!!!!!!!!In COUNTRY Execute!!!!!!!!!!!!!!!!!!!!!!!!!");
        try {
            Connection conn = DBConnectionFactory.getConnection();
            s_countries.clear();
            conn.setAutoCommit(false);
            PreparedStatement stat = conn.prepareStatement("SELECT * from COUNTRIES");
            ResultSet rs = stat.executeQuery();
            Trace.log(Utility.ApplicationLogger, Level.INFO, CountryList.class, "Execute",
                      "!!!!!!!!!!!!!!!!!Query Executed!!!!!!!!!!!!!!!!!!!!!!!!!");
            while (rs.next()) {
                String id = rs.getString("COUNTRY_ID");
                String name = rs.getString("COUNTRY_NAME");
                int regionId = rs.getInt("REGION_ID");
                Country c = new Country(id, name, regionId);
                s_countries.add(c);
            }
            rs.close();
        } catch (SQLException e) {
            System.err.println(e.getMessage());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Country getCountryById(String countryId) {
        Country c = null;
        int count = s_countries.size();
        for (int x = 0; x < count; x++) {
            c = (Country)s_countries.get(x);
            if (c.getId().compareTo(countryId) == 0) {
                break;
            }
        }
        return c;
    }

    public Country[] getCountries() {
        Country c[] = null;

        c = (Country[])s_countries.toArray(new Country[s_countries.size()]);

        return c;
    }
}
