package HR;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class Country {
    protected static RegionList regions = new RegionList();
    protected transient Region region = null;
    protected String id;
    protected String name;
    protected int regionId;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Country() {
        super();
    }
    
    public Country( String id, String name, int regionId) {
        setId(id);
        setName(name);
        setRegionId(regionId);
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        propertyChangeSupport.firePropertyChange("id", oldId, id);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getId() {
        return id;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        propertyChangeSupport.firePropertyChange("name", oldName, name);
    }

    public String getName() {
        return name;
    }

    public void setRegionId(int regionId) {
        int oldRegionId = this.regionId;
        this.regionId = regionId;
        propertyChangeSupport.firePropertyChange("regionId", oldRegionId, regionId);
    }

    public int getRegionId() {
        return regionId;
    }
    
    public Region getRegion() {
        if( region == null) {
            region = regions.getRegionById(getRegionId());
        }
        return region;
        
    }

}
