(function()
{
  try
  {
    /**
     * Mechanism to trigger an event.
     */
    window.customQueueEvent = function(eventTarget, eventName)
    {
      var event = document.createEvent("HTMLEvents");
      event.initEvent(eventName, true, true);
      event.eventName = eventName;
      event.memo = { };
      eventTarget.dispatchEvent(event);
    };

    /**
     * Try consuming the first item in the bookmark.
     */
    window.customConsumeBookmark = function()
    {
      if (window.customBookmarkArray.length > 0)
      {
        ++window.customConsumeBookmarkAttempt;
        // We have something to click but wait until the page is not loading:
        if (document.getElementById("amx-loading").className.indexOf("hidden") != -1)
        {
          var elementIdToTap = window.customBookmarkArray[0];
          var elementToTap = document.getElementById(elementIdToTap);
          if (elementToTap != null)
          {
            try
            {
              // Try either mouse or touch events (depends on platform which will work):
              window.customQueueEvent(elementToTap, "mousedown");
              window.customQueueEvent(elementToTap, "mouseup");
              window.customQueueEvent(elementToTap, "touchstart");
              window.customQueueEvent(elementToTap, "touchend");
            }
            catch (problem)
            {
              // eat the problem
            }

            // Move onto the next item in the array:
            window.customBookmarkArray.shift();
          }
        }

        if (window.customConsumeBookmarkAttempt < 100) // give up after many attempts
        {
          // Try again in a little bit:
          window.setTimeout(window.customConsumeBookmark, 100);
        }
      }
    };

    /**
     * When in hosted mode, these scripts assist with providing and handling the bookmarkable links.
     */
    window.customHandleBookmarkableLinks = function()
    {
      if (adf.mf.environment.profile.mockData == true)
      {
        document.body.className += " custom-mock-data";
        var href = window.location.href;
        var getLocationParams = function()
        {
          var params = {};
          if (href.indexOf("?") > 0)
          {
            var queryString = href.split("?")[1];
            var rawParams = queryString.split("&");
            for (var i=0, rawParamCount=rawParams.length; i<rawParamCount; ++i)
            {
              var rawParam = rawParams[i];
              var split = rawParam.split("=");
              if (split.length == 1) // name only
              {
                params[split[0]] = null;
              }
              else if (split.length == 2) // name and value
              {
                params[split[0]] = unescape(split[1]);
              }
            }
          }
          return params;
        }
        var params = getLocationParams();
        var pageToLoad = params["p"];
        if (pageToLoad != null && pageToLoad != "")
        {
          window.customBookmarkArray = pageToLoad.split("/");
          window.customConsumeBookmarkAttempt = 0;
          window.customConsumeBookmark();
        }

        // Add a link to the ADFui Home Page if applicable:
        if (href.indexOf("://rcf.us") != -1)
        {
          var link = document.createElement("a");
          link.setAttribute("href", "../rcf/");
          link.textContent = "ADFui Home Page";
          link.className = "custom-home-link";
          document.body.appendChild(link);
          document.body.className += " custom-home-link-shown";
        }
        else if (href.indexOf("://jdevadf.oracle.com") != -1)
        {
          var link = document.createElement("a");
          link.setAttribute("href", "http://www.oracle.com/technetwork/developer-tools/adf/overview/index.html");
          link.textContent = "ADF Home Page";
          link.className = "custom-home-link";
          document.body.appendChild(link);
          document.body.className += " custom-home-link-shown";
        }
      }
    }
    window.customHandleBookmarkableLinks();
  }
  catch (problem)
  {
    alert("Problem with custom code: " + problem);
  }
})();