package mobile;

import oracle.adf.model.datacontrols.device.DeviceManager;

import oracle.adf.model.datacontrols.device.DeviceManagerFactory;

import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class MyBean {
    String document = "doc.doc";
    String file;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public MyBean() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getDocument() {
        return document;
    }

    public void setDocument(String document) {
        String oldDocument = this.document;
        this.document = document;
        propertyChangeSupport.firePropertyChange("document", oldDocument, document);
    }

    public void setFile(String file) {
        String oldFile = this.file;
        this.file = file;
        propertyChangeSupport.firePropertyChange("file", oldFile, file);
    }

    public String getFile() {
        return file;
    }

    public void viewerHandler(ActionEvent actionEvent) {
        String dir = AdfmfJavaUtilities.getDirectoryPathRoot(AdfmfJavaUtilities.DownloadDirectory);
        String path = "file://" + dir + "/" + document;

        // Some encoding is necessary on the URL so it doesn't have spaces
        // replace " " with "%20" 
        StringBuffer buffer = new StringBuffer();
        String replacedString = " ";
        String replacement = "%20";
        int index = 0, previousIndex = 0;
        index = path.indexOf(replacedString, index);
        while (index != -1) {
            buffer.append(path.substring(previousIndex, index)).append(replacement);
            previousIndex = index + 1;
            index = path.indexOf(replacedString, index + replacedString.length());
        }
        buffer.append(path.substring(previousIndex, path.length()));

        setFile(buffer.toString());

        DeviceManager dm = DeviceManagerFactory.getDeviceManager();
        dm.displayFile(buffer.toString(), document);
    }

}
