<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">

    <xsl:variable name="insertNewLine">
      <xsl:text>&#10;</xsl:text>
    </xsl:variable>
    
    <xsl:value-of select="$insertNewLine"/> 
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE resources SYSTEM "rts.dtd"&gt;</xsl:text>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;resources xmlns="http://xmlns.oracle.com/bali/rts" package="oracle.adfmf.framework.dt.editor.resource"&gt;</xsl:text>
    <xsl:value-of select="$insertNewLine"/>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;!-- **** Auto Generated Content, please do not Edit **** --&gt;</xsl:text>
    <xsl:value-of select="$insertNewLine"/>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;!-- Element Descriptions --&gt;</xsl:text>
    <xsl:for-each select="xsd:schema/xsd:include/xsd:schema/xsd:element">
      <xsl:sort select="@name"/>
      <xsl:value-of select="$insertNewLine"/>
      <xsl:text disable-output-escaping="yes">&lt;resource key="ELEM_DESC_</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
      <xsl:value-of select="xsd:annotation/xsd:documentation"/>
      <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>
    </xsl:for-each>

    <xsl:value-of select="$insertNewLine"/>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;!-- Attribute Property Help Descriptions --&gt;</xsl:text>
      <xsl:for-each select="xsd:schema/xsd:include/xsd:schema/xsd:attributeGroup">
        <xsl:for-each select="xsd:attribute">
          <xsl:value-of select="$insertNewLine"/>
            <xsl:text disable-output-escaping="yes">&lt;resource key="ATTR_DESC_</xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
            <xsl:value-of select="xsd:annotation/xsd:documentation"/>
            <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>
          </xsl:for-each>
      </xsl:for-each>

      <xsl:for-each select="xsd:schema/xsd:include/xsd:schema/xsd:element">
      <xsl:variable name="parent">
        <xsl:value-of select="@name"/>
      </xsl:variable>
      <xsl:for-each select="xsd:complexType/xsd:attribute | xsd:complexType/xsd:simpleContent/xsd:extension/xsd:attribute">
        <xsl:value-of select="$insertNewLine"/>
        <xsl:text disable-output-escaping="yes">&lt;resource key="ATTR_DESC_</xsl:text>
        <xsl:value-of select="$parent"/>
        <xsl:text>_</xsl:text>
        <xsl:value-of select="@name"/>
        <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
        <xsl:call-template name="encode">
            <xsl:with-param name="string" select="xsd:annotation/xsd:documentation"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>

      </xsl:for-each>
    </xsl:for-each>

    <xsl:value-of select="$insertNewLine"/>
    <xsl:text disable-output-escaping="yes">&lt;/resources&gt;</xsl:text>

</xsl:template>

  <xsl:template name="encode" >
    <xsl:param name="string"/>
    <xsl:variable name="quotes" >
        <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
    </xsl:variable>
    <xsl:variable name="quotesReplacement">
        <xsl:text disable-output-escaping="yes">&amp;quot;</xsl:text>
    </xsl:variable>
    <xsl:variable name="newlineReplacement">
        <xsl:text disable-output-escaping="yes">&amp;#xA;</xsl:text>
    </xsl:variable>
    <xsl:variable name="newline">
        <xsl:text disable-output-escaping="yes">\n</xsl:text>
    </xsl:variable>
    <xsl:variable name="crReplacement">
        <xsl:text disable-output-escaping="yes">&amp;#xD;</xsl:text>
    </xsl:variable>
    <xsl:variable name="cr">
        <xsl:text disable-output-escaping="yes">\r</xsl:text>
    </xsl:variable>
    <xsl:variable name="tabReplacement">
        <xsl:text disable-output-escaping="yes">&amp;#x9;</xsl:text>
    </xsl:variable>
    <xsl:variable name="tab">
        <xsl:text disable-output-escaping="yes">\t</xsl:text>
    </xsl:variable>
	
    <xsl:variable name="replaceQuotes" >
      <xsl:call-template name="string-replace">
        <xsl:with-param name="from" select="$quotes"/>
        <xsl:with-param name="to" select="$quotesReplacement"/> 
        <xsl:with-param name="string" select="$string"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="replaceNewLine" >
      <xsl:call-template name="string-replace">
        <xsl:with-param name="from" select="$newline"/>
        <xsl:with-param name="to" select="$newlineReplacement"/> 
        <xsl:with-param name="string" select="$replaceQuotes"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="replaceCR" >
      <xsl:call-template name="string-replace">
        <xsl:with-param name="from" select="$cr"/>
        <xsl:with-param name="to" select="$crReplacement"/> 
        <xsl:with-param name="string" select="$replaceNewLine"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="string-replace">
      <xsl:with-param name="from" select="$tab"/>
      <xsl:with-param name="to" select="$tabReplacement"/> 
      <xsl:with-param name="string" select="$replaceCR"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="string-replace" >
    <xsl:param name="string"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:choose>
      <xsl:when test="contains($string,$from)">
        <xsl:value-of select="substring-before($string,$from)"/>
        <xsl:value-of select="$to"/>
        <xsl:call-template name="string-replace">
        <xsl:with-param name="string" select="substring-after($string,$from)"/>
        <xsl:with-param name="from" select="$from"/>
        <xsl:with-param name="to" select="$to"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>

