<?xml version="1.0" encoding="ISO-8859-1"?>

<!--Transform the combined xsd (adfmf-tagdoc-combined.xsd). The output is a html document for 
each ADF mobile element -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:fn="http://www.w3.org/2005/xpath-functions">
<html>
      <head>
        <title>ADF Mobile Framework Tag Library</title>
        <meta name="topic-id" content="ale1"/>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
        <link rel="stylesheet" type="text/css" href="css/blafdoc.css"></link>
        <link rel="stylesheet" type="text/css" href="css/adfmf-styles.css"></link>
      </head>
      <body>
        <table width="100%" border="0">
          <tr>
            <td align="right" valign="top" rowspan="3">
              <em>
                <b>
                  Oracle Fusion Middleware Tag Reference for Oracle ADF Mobile 
                  <br/>
                  11g Release 2 (11.1.2.4.0)
                </b>
                <br/>
                E26230-02
              </em>
            </td>
          </tr>
        </table>
        <p></p>
        <h2>Tag Library Information</h2>
        <p></p>
        <b>Short name:</b>
        adfmf
        <br/>
        <b>Namespace:</b>
        http://xmlns.oracle.com/adf/mf, http://xmlns.oracle.com/adf/mf/amx, http://xmlns.oracle.com/adf/mf/amx/dvt, http://xmlns.oracle.com/adf/mf/skin, http://xmlns.oracle.com/adf/mf/config 
        <br/>
        <p></p>
        <h2>Links</h2>
        <p></p>
        <xsl:for-each select="xsd:schema/xsd:include">
     <xsl:variable name="uid">
         <xsl:call-template name="getSchemaFileName">  
           <xsl:with-param name="path" select="@schemaLocation" />
         </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="displayname">
	<xsl:if test="starts-with($uid,'adfmf-')">
	  <xsl:value-of select="translate(substring(substring-after($uid,'adfmf-'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-after($uid,'adfmf-'),2,string-length($uid))"/>
 	</xsl:if>
	<xsl:if test="starts-with($uid,'adf-mobile-')">
	  <xsl:value-of select="translate(substring(substring-after($uid,'adf-mobile-'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-after($uid,'adf-mobile-'),2,string-length($uid))"/>
 	</xsl:if>
	<xsl:if test="starts-with($uid,'dvt-mobile-')">
	  <xsl:value-of select="translate(substring(substring-before($uid,'-mobile-amx'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-before($uid,'-mobile-amx'),2,string-length($uid))"/>
 	</xsl:if>
     </xsl:variable>

        <ul>
            <li>
              <a href="#{$uid}">
                <xsl:value-of select="$displayname"/>
                Components
              </a>
            </li>
          </ul>

  </xsl:for-each>
        <p></p>
        <xsl:for-each select="xsd:schema/xsd:include">

     <xsl:variable name="uid">
         <xsl:call-template name="getSchemaFileName">  
           <xsl:with-param name="path" select="@schemaLocation" />
         </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="displayname">
	<xsl:if test="starts-with($uid,'adfmf-')">
	  <xsl:value-of select="translate(substring(substring-after($uid,'adfmf-'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-after($uid,'adfmf-'),2,string-length($uid))"/>
 	</xsl:if>
	<xsl:if test="starts-with($uid,'adf-mobile-')">
	  <xsl:value-of select="translate(substring(substring-after($uid,'adf-mobile-'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-after($uid,'adf-mobile-'),2,string-length($uid))"/>
 	</xsl:if>
	<xsl:if test="starts-with($uid,'dvt-mobile-')">
	  <xsl:value-of select="translate(substring(substring-before($uid,'-mobile-amx'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-before($uid,'-mobile-amx'),2,string-length($uid))"/>
 	</xsl:if>
     </xsl:variable>

<a name="{$uid}"></a>


<h2><xsl:value-of select="$displayname"/> Components</h2>

<table class="children" summary="">
            <thead>
              <tr>
                <th class="children">Name</th>
                <th class="children">Description</th>
              </tr>
            </thead>
   <xsl:for-each select="xsd:schema">
   <xsl:variable name="namespace">
      <xsl:call-template name="getNamespace">
        <xsl:with-param name="targetNamespace" select="@targetNamespace"/>
      </xsl:call-template>
    </xsl:variable>
  <xsl:for-each select=".//xsd:element[@name]">
    <xsl:sort select="@name"/>   
    <!-- qualified element name -->
    <xsl:variable name="elementName">
      <xsl:value-of select="$namespace"/>:<xsl:value-of select="@name"/>
    </xsl:variable>
  
    <tr>
                <td class="children">
                  <a href="#{$elementName}">
                    &lt;<xsl:value-of select="$elementName"/>&gt;
                  </a>
                </td>
                <td class="children">
                  <xsl:value-of select="xsd:annotation/xsd:documentation"/>
                </td>
              </tr>
  </xsl:for-each>
  </xsl:for-each>
    <xsl:for-each select="xsd:schema/xsd:include">
     <xsl:sort select="@schemaLocation"/>

     <xsl:variable name="uid2">
         <xsl:call-template name="getSchemaFileName">  
           <xsl:with-param name="path" select="@schemaLocation" />
         </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="displayname2">
	<xsl:if test="starts-with($uid2,'adfmf-')">
   	  <xsl:value-of select="translate(substring(substring-after($uid2,'adfmf-'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-after($uid2,'adfmf-'),2,string-length($uid2))"/>
 	</xsl:if>
	<xsl:if test="starts-with($uid2,'adf-mobile-')">
	  <xsl:value-of select="translate(substring(substring-after($uid2,'adf-mobile-'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-after($uid2,'adf-mobile-'),2,string-length($uid2))"/>
 	</xsl:if>
	<xsl:if test="starts-with($uid2,'dvt-mobile-')">
	  <xsl:value-of select="translate(substring(substring-before($uid2,'-mobile-amx'),1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	  <xsl:value-of select="substring(substring-before($uid2,'-mobile-amx'),2,string-length($uid2))"/>
 	</xsl:if>
     </xsl:variable>

    <tr>
                <td class="children">
                  <a href="#{$uid2}">
                    <xsl:value-of select="$displayname2"/> Components
                  </a>
                </td>
                <td class="children">
                  <xsl:value-of select="$displayname2"/>
                  components may also be included in this context.
                </td>
              </tr>
  </xsl:for-each>
          </table>

</xsl:for-each>
        <p/>
        <p/>
        <hr class="tag-separator"/>
        <p/>
        <p/>
        <!--=================================================================-->
        <!--===================  Individual TAG Areas =======================-->
        <xsl:for-each select="xsd:schema/xsd:include/xsd:schema">
        <xsl:variable name="namespace">
           <xsl:call-template name="getNamespace">
             <xsl:with-param name="targetNamespace" select="@targetNamespace"/>
           </xsl:call-template>
         </xsl:variable>
         
         <xsl:variable name="targetNamespace">
           <xsl:value-of select="@targetNamespace"/>
         </xsl:variable>
         
         <xsl:for-each select=".//xsd:element[@name]">
         <xsl:sort select="@name"/>

         <xsl:variable name="type">
            <xsl:value-of select="@type"/>
         </xsl:variable>
         
         <xsl:variable name="tagValue">
           <xsl:value-of select="$namespace"/>:<xsl:value-of select="@name"/>
         </xsl:variable>

            <a name="{$tagValue}">
              <table>
                <thead>
                  <tr>
                    <th class="tagname">Tag name:</th>
                    <th class="tagvalue">
                      &lt;<xsl:value-of select="$tagValue"/>&gt;
                    </th>
                  </tr>
                </thead>
              </table>
            </a>

            <p/>
            <xsl:value-of select="xsd:annotation/xsd:documentation"/>
            <p/>

<!--=================================================================-->
<!--======================  TAG Attributes ==========================-->
       <xsl:choose>
         <xsl:when test="not(@abstract)">

           <h2 class="attributes">Attributes</h2>

           <xsl:choose>
              <xsl:when test="xsd:complexType/xsd:attribute | xsd:complexType/xsd:attributeGroup | xsd:complexType/xsd:simpleContent/xsd:extension/xsd:attribute | xsd:complexType/xsd:simpleContent/xsd:extension/xsd:attributeGroup">
                                
                 <table class="attributes" summary="">
                  <thead>
                    <tr>
                      <th class="attributes">Name</th>
                      <th class="attributes">Type</th>
                      <th class="attributes">Required?</th>
                      <th class="attributes">Supports EL?</th>
                      <th class="attributes">Description</th>
                    </tr>
                  </thead>
                  
                  <xsl:for-each select="xsd:complexType">
                    <xsl:call-template name="listAttributes">
                    </xsl:call-template>
                  </xsl:for-each>                                                                                                                                                
                </table>
              </xsl:when>
              <xsl:otherwise>
                  <xsl:choose>
                    <xsl:when test="@type">
                      <xsl:choose>
                        <xsl:when test="../xsd:complexType[@name=substring-after($type,':')]">
                          <!-- complex type --> 
                          <table class="attributes" summary="">
                            <thead>
                              <tr>
                               <th class="attributes">Name</th>
                               <th class="attributes">Type</th>
                               <th class="attributes">Required?</th>
                               <th class="attributes">Supports EL?</th>
                               <th class="attributes">Description</th>
                              </tr>
                           </thead>
					    
                          <xsl:for-each select="../xsd:complexType[@name=substring-after($type,':')]">
                            <xsl:for-each select="xsd:complexContent/xsd:extension">
                              <xsl:call-template name="listAttributes">
                              </xsl:call-template>
                            </xsl:for-each>
                         </xsl:for-each>
                       </table>
                     </xsl:when>
                     <xsl:otherwise>
                       <!--built-in type-->
                        None.        
                     </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>					
                  <xsl:otherwise>
                     None.
                  </xsl:otherwise>
                </xsl:choose>              
              </xsl:otherwise>
            </xsl:choose>

           <p/>

<!--=================================================================-->
<!--======================  TAG Children ============================-->
<!--Output the child elements-->
<!--The element has children in the following cases: 
  (1) element definition has sequence/choice/all
  (2) element definition has type attribute and the type is a complex type and the complex
      type has sequence/choice/all defined  
  For all other cases, output "None" to indicate the element has no children.--> 
<h2 class="children">Child Elements</h2>

        <xsl:choose>
             <xsl:when test="xsd:complexType/xsd:sequence | xsd:complexType/xsd:all | xsd:complexType/xsd:choice ">
               <xsl:for-each select="xsd:complexType">
                 <xsl:call-template name="listChildren">
                   <xsl:with-param name="nsprefix" select="$namespace"/>
                 </xsl:call-template>
                  
               </xsl:for-each>
             </xsl:when>
             <xsl:otherwise>
                <xsl:choose> 
                    <xsl:when test="@type">
                      <xsl:choose>
                        <xsl:when test="../xsd:complexType[@name=substring-after($type,':')]">							  
                          <xsl:for-each select="../xsd:complexType[@name=substring-after($type,':')]"> 
                           <xsl:choose>													
                            <xsl:when test="xsd:complexContent/xsd:extension/xsd:sequence | xsd:complexContent/xsd:extension/xsd:choice | xsd:complexContent/xsd:extension/xsd:all">										
                              <xsl:for-each select="xsd:complexContent/xsd:extension">										  
                                <xsl:call-template name="listChildren">
                                   <xsl:with-param name="nsprefix" select="$namespace"/>
                                </xsl:call-template>
                              </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>
                              None.
                            </xsl:otherwise>
                           </xsl:choose>      
                          </xsl:for-each>        
                         </xsl:when>                     
                        <xsl:otherwise>
                           None.
                        </xsl:otherwise>
                     </xsl:choose>
                   </xsl:when>   
                   <xsl:otherwise>										
                      None.
                  </xsl:otherwise>        
                 </xsl:choose>
             </xsl:otherwise>
        </xsl:choose>  
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="baseName" select="@name"/>
        <xsl:for-each select="../../../xsd:include/xsd:schema">
          <xsl:variable name="currentNamespace">
            <xsl:call-template name="getNamespace">
              <xsl:with-param name="targetNamespace" select="@targetNamespace"/>
            </xsl:call-template>
          </xsl:variable>
          <xsl:for-each select="xsd:element[@substitutionGroup]">
            <xsl:sort select="@name"/>
            <xsl:variable name="elemName">
              <!--qualified element name-->
              <xsl:value-of select="$currentNamespace"/>:<xsl:value-of select="@name"/>
            </xsl:variable>
            <xsl:if test="substring-after(@substitutionGroup,':')=$baseName">
               <a href="#{$elemName}">&lt;<xsl:value-of select="$elemName"/>&gt;</a>
               <br/>
            </xsl:if>     
           </xsl:for-each>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose> 
<p/>

<!--=================================================================-->
<!--======================  End of Tag Area =========================-->

<p/>
<p/>
<hr class="tag-separator"/>
<p/>
<p/>


</xsl:for-each>
</xsl:for-each>
        <!-- Start Footer -->
        <!-- class="ind" -->
        <div class="footer">
          <table class="simple oac_no_warn" summary="" cellspacing="0" cellpadding="0" width="100%">
            <tr>
              <td align="left" width="86%">
                <a href="topicid:help_legalnotices_html">
                  <span class="copyrightlogo">Copyright 2012, 2013 Oracle. All rights reserved.</span>
                </a>
              </td>
            </tr>
          </table>
          <p></p>
        </div>
        <!-- class="footer" -->
      </body>
    </html>

</xsl:template>

<!-- *********************************************************************************************
 Output each of the element's attributes with the following information: Attribute Name, Type, 
 Required, Supports EL and Description.  Those information is listed in a row of the table.
 This template can be called at <xsd:attribute>
 ********************************************************************************************* -->
<xsl:template name="listAttribute" match="xsd:attribute" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
                     <tr>
                      <td class="attributes">
                        <xsl:value-of select="@name"/>
                      </td>
                      <td class="attributes">
                        <xsl:value-of select="substring-after(@type,':')"/>
                      </td>
                      <td class="attributes">
                        <xsl:choose>
                          <xsl:when test="@use = 'required'">
                             Yes
                          </xsl:when>
                          <xsl:otherwise>
                             No
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                      <td class="attributes">
                       <xsl:variable name="type">
                           <xsl:value-of select="substring-after(@type,':')"/>
                        </xsl:variable>
                        <xsl:choose>
                           <xsl:when test="$type='elExpression'">Yes</xsl:when>
                           <xsl:otherwise>
                             <xsl:choose>
                             <!--When simpleType has union element, go to union -->
                               <xsl:when test="//xsd:include/xsd:schema/xsd:simpleType[@name=$type]/xsd:union">
                                <xsl:for-each select="//xsd:include/xsd:schema/xsd:simpleType[@name=$type]/xsd:union">
                                  <xsl:choose>
                                     <xsl:when test="contains(@memberTypes, 'elExpression')">
                                        Yes
                                     </xsl:when>
                                     <xsl:otherwise>
                                         No
                                     </xsl:otherwise>
                                 </xsl:choose>
                                </xsl:for-each>
                             </xsl:when>
                               <xsl:otherwise>
                                 No
                               </xsl:otherwise>
                              </xsl:choose>
                           </xsl:otherwise>    
                        </xsl:choose>                                            
                      </td>
                      <td class="attributes">
                        <xsl:value-of select="xsd:annotation/xsd:documentation" disable-output-escaping="yes"/>
                      </td>
                    </tr>
</xsl:template>

<!-- *********************************************************************************************
 Output one row of child element with element name, Minimum Occurrences and Maximum Occurrences.
 This template can be called at <xsd:element>.  It has the following input parameters: 
 the element's minOccurs value, the element's maxOccurs value and the namespace prefix. 
 ********************************************************************************************* -->
<xsl:template name="childElements" match="xsd:element" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
              <xsl:param name="minOccurs"/>
              <xsl:param name="maxOccurs"/>
              <xsl:param name="prefix"/>
                   <tr>
                      <td class="children">
                       <xsl:choose>
                        <xsl:when test="@ref">																			
                          <a href="#{@ref}">
                          &lt;<xsl:value-of select="@ref"/>&gt;
                          </a>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:variable name="qualifiedName">
                            <xsl:value-of select="$prefix"/>:<xsl:value-of select="@name"/>
                          </xsl:variable>
                          <a href="#{$qualifiedName}">
                            &lt;<xsl:value-of select="$qualifiedName"/>&gt;
                          </a>
                        </xsl:otherwise>
                        </xsl:choose>
                      </td>
                      <td class="children">
                        <xsl:value-of select="$minOccurs"/>
                      </td>
                      <td class="children">
                        <xsl:value-of select="$maxOccurs"/>
                      </td>
                    </tr>
</xsl:template>

<!-- *********************************************************************************************
 Get the schema file name without the .xsd suffix
 ********************************************************************************************* -->
<xsl:template name="getSchemaFileName">
<xsl:param name="path"/>

  <xsl:choose>
    <xsl:when test="contains($path, '/')">
    <xsl:call-template name="getSchemaFileName">
      <xsl:with-param name="path" select="substring-after($path, '/')"/>
    </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="substring-before($path,'.xsd')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- *********************************************************************************************
 Output the child elements in a table.  To call this template, the element must have child 
 element(s). This template has the following input parameters: 
 namespace prefix (namespaceprefix) 
 ********************************************************************************************* -->
<xsl:template name="listChildren" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <xsl:param name="nsprefix"/>
   
                <table class="children" summary="">
                  <thead>
                    <tr>
                      <th class="children">Child Element</th>
                      <th class="children">Minimum Occurrences</th>
                      <th class="children">Maximum Occurrences</th>
                    </tr>
                  </thead>
                  
                  <xsl:apply-templates select="xsd:sequence/xsd:element">    
                    <xsl:with-param name="namespaceprefix"     select="$nsprefix" />      
                   </xsl:apply-templates>
                  <xsl:apply-templates select="xsd:all/xsd:element">
                    <xsl:with-param name="namespaceprefix"     select="$nsprefix" />                          
                  </xsl:apply-templates>
                  <xsl:apply-templates select="xsd:choice/xsd:element">
                    <xsl:with-param name="namespaceprefix"     select="$nsprefix" />                      
                  </xsl:apply-templates>
                  
                  <!-- Now process the groups; like above, we have to get a referenced group -->
                  <xsl:apply-templates select="xsd:sequence/xsd:group">
                    <xsl:with-param name="namespaceprefix" select="$nsprefix" />                      
                  </xsl:apply-templates>
                  <xsl:apply-templates select="xsd:choice/xsd:group">
                    <xsl:with-param name="namespaceprefix"     select="$nsprefix" />                        
                  </xsl:apply-templates>
                </table>
</xsl:template>

<!-- *********************************************************************************************
 Output the elements in a table.  
 This template has the following input parameters: 
 namespace prefix (namespaceprefix) 
 ********************************************************************************************* -->
<xsl:template match="xsd:element" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <xsl:param name="namespaceprefix"/>
  <xsl:call-template name="childElements" > 
    <xsl:with-param name="minOccurs" select="@minOccurs" />
    <xsl:with-param name="maxOccurs" select="@maxOccurs" />    
    <xsl:with-param name="prefix"     select="$namespaceprefix" />      
  </xsl:call-template>
</xsl:template>

<!-- *********************************************************************************************
 Output the elements specified in the group in a table.  
 This template has the following input parameters: 
 namespace prefix (namespaceprefix) 
 ********************************************************************************************* -->
<xsl:template match="xsd:group" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <xsl:param name="namespaceprefix"/>
  <xsl:variable name="grpMin" select="@minOccurs" />
  <xsl:variable name="grpMax" select="@maxOccurs" />
  <xsl:variable name="groupNamespace">
    <xsl:call-template name="getTargetNamespaceByPrefix">
      <xsl:with-param name="prefix" select="substring-before(current()/@ref,':')"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:for-each select="//xsd:include/xsd:schema[@targetNamespace=$groupNamespace]/xsd:group[@name=substring-after(current()/@ref,':')]/xsd:choice/xsd:element"> 
    <xsl:call-template name="childElements">  
      <xsl:with-param name="minOccurs" select="$grpMin" />
      <xsl:with-param name="maxOccurs" select="$grpMax" /> 
      <xsl:with-param name="prefix"     select="$namespaceprefix" />                        
    </xsl:call-template>
  </xsl:for-each>
</xsl:template>

<!-- *********************************************************************************************
 Output the attributes in a table.  This template can be called at "xsd:complexType" or at
 "xsd:complexType/xsd:complexContent/xsd:extension" or "xsd:complexType/xsd:simpleContent/xsd:extension". 
 
 It will list each attribute, and go through 
 each attributeGroup recursively to list each attribute.
 
 ********************************************************************************************* -->
<xsl:template name="listAttributes" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <xsl:for-each select="xsd:attribute | xsd:simpleContent/xsd:extension/xsd:attribute">
    <xsl:call-template name="listAttribute" />  <!-- Process xsd:attribute children -->
   </xsl:for-each>
   <!-- Now do the rows for attributeGroup attributes -->
   <xsl:if test="xsd:attributeGroup">
   <xsl:for-each select="xsd:attributeGroup | xsd:simpleContent/xsd:extension/xsd:attributeGroup">
     <xsl:variable name="attrGroupNamespace">
       <xsl:call-template name="getTargetNamespaceByPrefix">
         <xsl:with-param name="prefix" select="substring-before(current()/@ref,':')"/>
       </xsl:call-template>
     </xsl:variable>
     <xsl:apply-templates select="//xsd:include/xsd:schema[@targetNamespace=$attrGroupNamespace]/xsd:attributeGroup[@name=substring-after(current()/@ref,':')]">
       <xsl:with-param name="targetNamespace" select="$attrGroupNamespace"/>
     </xsl:apply-templates>
  </xsl:for-each>   
  </xsl:if> 
</xsl:template>


<!-- *********************************************************************************************
 Handle the attributeGroup recursively
 ********************************************************************************************* -->
 <xsl:template match="xsd:attributeGroup" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <xsl:param name="targetNamespace"/>
   <xsl:for-each select="xsd:attribute">
     <xsl:call-template name="listAttribute" />  
   </xsl:for-each>
   <xsl:if test="xsd:attributeGroup">
     <xsl:for-each select="xsd:attributeGroup">
       <xsl:variable name="attrGroupNamespace">
         <xsl:call-template name="getTargetNamespaceByPrefix">
           <xsl:with-param name="prefix" select="substring-before(current()/@ref,':')"/>
         </xsl:call-template>
       </xsl:variable>
       <xsl:apply-templates select="//xsd:include/xsd:schema[@targetNamespace=$attrGroupNamespace]/xsd:attributeGroup[@name=substring-after(current()/@ref,':')]"/>
     </xsl:for-each> 
   </xsl:if>
 </xsl:template>



<!-- *********************************************************************************************
 Get the namespace prefix from namespace node.  This template should be called at <xsd:schema>
 ********************************************************************************************* -->
<xsl:template name="getNamespace">
  <xsl:param name="targetNamespace"/>
  <xsl:for-each select=" namespace::*
             [. = $targetNamespace]">
      <xsl:value-of select="name()"/>
   </xsl:for-each>
</xsl:template>


<xsl:template name="getTargetNamespaceByPrefix">
  <xsl:param name="prefix"/>
  <xsl:choose>
    <xsl:when test="$prefix='adfmf'">http://xmlns.oracle.com/adf/mf</xsl:when>
    <xsl:when test="$prefix='amx'">http://xmlns.oracle.com/adf/mf/amx</xsl:when>
    <xsl:when test="$prefix='dvtm'">http://xmlns.oracle.com/adf/mf/amx/dvt</xsl:when>
    <xsl:when test="$prefix='skin'">http://xmlns.oracle.com/adf/mf/skin</xsl:when>
    <xsl:when test="$prefix='config'">http://xmlns.oracle.com/adf/mf/config</xsl:when>
    <xsl:otherwise>Unknown prefix value: <xsl:value-of select="$prefix"/></xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>


