<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:include href="../../../framework/dt/editor/config/adfmf-framework-descriptions.xsl" />
  <xsl:template match="/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
  
    <xsl:variable name="insertNewLine">
      <xsl:text>&#10;</xsl:text>
    </xsl:variable>
    
    <xsl:value-of select="$insertNewLine"/>
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE resources SYSTEM "rts.dtd"&gt;</xsl:text>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;resources xmlns="http://xmlns.oracle.com/bali/rts" package="oracle.adfmf.amx.dt.metadata.resource"&gt;</xsl:text>
    <xsl:value-of select="$insertNewLine"/>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;!-- **** Auto Generated Content, please do not Edit **** --&gt;</xsl:text>
    <xsl:value-of select="$insertNewLine"/>
    <xsl:value-of select="$insertNewLine"/>

    <xsl:text disable-output-escaping="yes">&lt;!-- Element Descriptions --&gt;</xsl:text>
    <xsl:for-each select="xsd:schema/xsd:include/xsd:schema/xsd:element">
      <xsl:sort select="@name"/>
      <!-- skip abstract elements, e.g. amx:uiComponent -->
      <xsl:if test="not(@abstract)">
        <xsl:value-of select="$insertNewLine"/>
        <xsl:text disable-output-escaping="yes">&lt;resource key="ELEM_DESC_</xsl:text>
        <xsl:value-of select="@name"/>
        <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
        <xsl:value-of select="xsd:annotation/xsd:documentation"/>
        <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>
      </xsl:if>
    </xsl:for-each>
  
    <xsl:value-of select="$insertNewLine"/>
    <xsl:value-of select="$insertNewLine"/>
  
    <xsl:text disable-output-escaping="yes">&lt;!-- Attribute Property Help Descriptions --&gt;</xsl:text>
    <xsl:for-each select="xsd:schema/xsd:include/xsd:schema/xsd:attributeGroup">
        <xsl:for-each select="xsd:attribute">
            <xsl:text>&#10;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;resource key="ATTR_DESC_</xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
            <xsl:value-of select="xsd:annotation/xsd:documentation"/>
            <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>
      </xsl:for-each>
    </xsl:for-each>
    
    <xsl:for-each select="xsd:schema/xsd:include/xsd:schema/xsd:element">
          <xsl:variable name="parent">
            <xsl:value-of select="@name"/>
          </xsl:variable>
          <!-- generate resource strings for attributes inherited from a base type -->
          <xsl:if test="@type">
            <xsl:variable name="type">
                <xsl:value-of select="substring-after(@type, ':')"/>
            </xsl:variable>
            <xsl:for-each select="/xsd:schema/xsd:include/xsd:schema/xsd:complexType[@name=$type]">
              <xsl:for-each select="xsd:complexContent/xsd:extension/xsd:attribute">
                <xsl:value-of select="$insertNewLine"/>
                <xsl:text disable-output-escaping="yes">&lt;resource key="ATTR_DESC_</xsl:text>
                <xsl:value-of select="$parent"/>
                <xsl:text>_</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
                <xsl:call-template name="encode">
                        <xsl:with-param name="string" select="xsd:annotation/xsd:documentation"/>
                </xsl:call-template>
                <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:if>
          <!-- generate resource strings for attributes defined on the element -->
          <xsl:for-each select="xsd:complexType/xsd:attribute">
            <xsl:value-of select="$insertNewLine"/>
            <xsl:text disable-output-escaping="yes">&lt;resource key="ATTR_DESC_</xsl:text>
            <xsl:value-of select="$parent"/>
            <xsl:text>_</xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
            <xsl:call-template name="encode">
                    <xsl:with-param name="string" select="xsd:annotation/xsd:documentation"/>
            </xsl:call-template>
            <xsl:text disable-output-escaping="yes">&lt;/resource&gt;</xsl:text>
          </xsl:for-each>
    </xsl:for-each>
  
    <xsl:value-of select="$insertNewLine"/>
    <xsl:text disable-output-escaping="yes">&lt;/resources&gt;</xsl:text>
  </xsl:template>

</xsl:stylesheet>

