package oracle.adf.model.datacontrols.application;

import oracle.adfmf.framework.ApplicationInformation;
import oracle.adfmf.framework.FeatureInformation;
import oracle.adfmf.framework.exception.AdfException;

/**
 * Application Features data control class. This class encapsulates application
 * features such as hide/show navigation bar, enumerate application features, 
 * etc. This is used directly by JDeveloper to expose these services at design
 * time in the DataControl palette.
 */
public class ApplicationFeatures
{

  private static final ApplicationFeaturesImpl APPLICATION_FEATURES_IMPL = ApplicationFeaturesImpl.getInstance();

  /**
   * Navigates the application to the passed in feature
   * 
   * @param featureId
   *          - Id of the feature
   * 
   */
  public void gotoFeature(String featureId)
  {
    APPLICATION_FEATURES_IMPL.gotoFeature(featureId);
  }
  
  /**
   * Retrieves the application information of the current application
   * 
   * @return a <code>ApplicationInformation</code> object containing various
   *         attributes of the application
   * 
   */
  public ApplicationInformation getApplicationInformation()
  {
    return APPLICATION_FEATURES_IMPL.getApplicationInformation();
  }
  
  /**
   * Hides the navigation bar if visible
   * 
   */
  public void hideNavigationbar()
  {
    APPLICATION_FEATURES_IMPL.hideNavigationbar();
  }
  
  /**
   * Shows the navigation bar
   * 
   */
  public void showNavigationbar()
  {
    APPLICATION_FEATURES_IMPL.showNavigationbar();
  }
  
  /**
   * Retrieves the feature definition for all the features that are visible on
   * the springboard in the current application
   * 
   * @return an array of <code>FeatureInformation</code> object containing
   *         various attributes of the feature
   * 
   */
  public FeatureInformation[] getFeatures()
  {
    return APPLICATION_FEATURES_IMPL.getFeatures();
  }  
  
  /**
   * Resets the state of the passed in feature
   * 
   * @param featureId
   *          - Id of the feature to be reset
   * 
   */
  public void resetFeature(String featureId)
  {
    APPLICATION_FEATURES_IMPL.resetFeature(featureId);
  }
  
  /**
   * Activates the springboard
   * 
   */
  public void gotoSpringboard()
  {
    APPLICATION_FEATURES_IMPL.gotoSpringboard();
  }
  
  /**
   * Navigates the application to the default feature
   * 
   */
  public void gotoDefaultFeature()
  {
    APPLICATION_FEATURES_IMPL.gotoDefaultFeature();
  }

  /**
   * Returns the feature information for the passed in feature id.
   * 
   * @param featureId
   *          ID of the feature to retrieve
   * @throws AdfException
   */
  public FeatureInformation getFeatureById(String featureId) throws AdfException
  {
    return APPLICATION_FEATURES_IMPL.getFeatureById(featureId);
  }

  /**
   * Returns the feature information for the passed in feature name.
   * 
   * @param featureName
   *          Name of the feature to retrieve
   * @throws AdfException
   */
  public FeatureInformation getFeatureByName(String featureName) throws AdfException
  {
    return APPLICATION_FEATURES_IMPL.getFeatureByName(featureName);
  }

}
