/*
 * @(#)Subject.java	1.121 06/08/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package javax.security.auth;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;
import java.text.MessageFormat;
import java.security.AccessController;
import java.security.AccessControlContext;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;

/**
 * <p> A <code>Subject</code> represents a grouping of related information
 * for a single entity, such as a person.
 * Such information includes the Subject's identities as well as
 * its security-related attributes
 * (passwords and cryptographic keys, for example).
 *
 * <p> Subjects may potentially have multiple identities.
 * Each identity is represented as a <code>Principal</code>
 * within the <code>Subject</code>.  Principals simply bind names to a
 * <code>Subject</code>.  For example, a <code>Subject</code> that happens
 * to be a person, Alice, might have two Principals:
 * one which binds "Alice Bar", the name on her driver license,
 * to the <code>Subject</code>, and another which binds,
 * "999-99-9999", the number on her student identification card,
 * to the <code>Subject</code>.  Both Principals refer to the same
 * <code>Subject</code> even though each has a different name.
 *
 * <p> A <code>Subject</code> may also own security-related attributes,
 * which are referred to as credentials.
 * Sensitive credentials that require special protection, such as
 * private cryptographic keys, are stored within a private credential
 * <code>Set</code>.  Credentials intended to be shared, such as
 * public key certificates or Kerberos server tickets are stored
 * within a public credential <code>Set</code>.  Different permissions
 * are required to access and modify the different credential Sets.
 *
 * <p> To retrieve all the Principals associated with a <code>Subject</code>,
 * invoke the <code>getPrincipals</code> method.  To retrieve
 * all the public or private credentials belonging to a <code>Subject</code>,
 * invoke the <code>getPublicCredentials</code> method or
 * <code>getPrivateCredentials</code> method, respectively.
 * To modify the returned <code>Set</code> of Principals and credentials,
 * use the methods defined in the <code>Set</code> class.
 * For example:
 * <pre>
 *	Subject subject;
 *	Principal principal;
 *	Object credential;
 *
 *	// add a Principal and credential to the Subject
 *	subject.getPrincipals().add(principal);
 *	subject.getPublicCredentials().add(credential);
 * </pre>
 *
 * <p> This <code>Subject</code> class implements <code>Serializable</code>.
 * While the Principals associated with the <code>Subject</code> are serialized,
 * the credentials associated with the <code>Subject</code> are not.
 * Note that the <code>java.security.Principal</code> class
 * does not implement <code>Serializable</code>.  Therefore all concrete
 * <code>Principal</code> implementations associated with Subjects
 * must implement <code>Serializable</code>.
 *
 * @version 1.121, 08/10/06
 * @see java.security.Principal
 * @see java.security.DomainCombiner
 */
public final class Subject implements java.io.Serializable {
    
    
    
    
    
    
    
    
    
    /**
     * Create an instance of a <code>Subject</code>
     * with an empty <code>Set</code> of Principals and empty
     * Sets of public and private credentials.
     *
     * <p> The newly constructed Sets check whether this <code>Subject</code>
     * has been set read-only before permitting subsequent modifications.
     * The newly created Sets also prevent illegal modifications
     * by ensuring that callers have sufficient permissions
     * (to modify the Principals Set, the caller must have
     * <code>AuthPermission("modifyPrincipals")</code>, for example).
     */
    public Subject() {}
    
    /**
     * Create an instance of a <code>Subject</code> with
     * the specified Sets of Principals and credentials.
     *
     * <p> The specified Sets must check whether this <code>Subject</code>
     * has been set read-only before permitting subsequent modifications.
     * The specified Sets must also prevent illegal modifications
     * by ensuring that callers have sufficient permissions.
     *
     * <p>
     *
     * @param readOnly true if the <code>Subject</code> is to be read-only,
     *		and false otherwise. <p>
     *
     * @param principals the <code>Set</code> of Principals
     *		to be associated with this <code>Subject</code>. <p>
     *
     * @param pubCredentials the <code>Set</code> of public credentials
     *		to be associated with this <code>Subject</code>. <p>
     *
     * @param privCredentials the <code>Set</code> of private credentials
     *		to be associated with this <code>Subject</code>.
     *
     * @exception NullPointerException if the specified
     *		<code>principals</code>, <code>pubCredentials</code>,
     *		or <code>privCredentials</code> are <code>null</code>.
     */
    public Subject(boolean readOnly, Set principals, Set pubCredentials, Set privCredentials) {}
    
    /**
     * Set this <code>Subject</code> to be read-only.
     *
     * <p> Modifications (additions and removals) to this Subject's
     * <code>Principal</code> <code>Set</code> and
     * credential Sets will be disallowed.
     * The <code>destroy</code> operation on this Subject's credentials will
     * still be permitted.
     *
     * <p> Subsequent attempts to modify the Subject's <code>Principal</code>
     * and credential Sets will result in an
     * <code>IllegalStateException</code> being thrown.
     * Also, once a <code>Subject</code> is read-only,
     * it can not be reset to being writable again.
     *
     * <p>
     *
     * @exception SecurityException if the caller does not have permission
     *		to set this <code>Subject</code> to be read-only.
     */
    public void setReadOnly() {
        return ;
    }
    
    /**
     * Query whether this <code>Subject</code> is read-only.
     *
     * <p>
     *
     * @return true if this <code>Subject</code> is read-only, false otherwise.
     */
    public boolean isReadOnly() {
        return false;
    }
    
    /**
     * Get the <code>Subject</code> associated with the provided
     * <code>AccessControlContext</code>.
     *
     * <p> The <code>AccessControlContext</code> may contain many
     * Subjects (from nested <code>doAs</code> calls).
     * In this situation, the most recent <code>Subject</code> associated
     * with the <code>AccessControlContext</code> is returned.
     *
     * <p>
     *
     * @param  acc the <code>AccessControlContext</code> from which to retrieve
     *		the <code>Subject</code>.
     *
     * @return  the <code>Subject</code> associated with the provided
     *		<code>AccessControlContext</code>, or <code>null</code>
     *		if no <code>Subject</code> is associated
     *		with the provided <code>AccessControlContext</code>.
     *
     * @exception SecurityException if the caller does not have permission
     *		to get the <code>Subject</code>. <p>
     *
     * @exception NullPointerException if the provided
     *		<code>AccessControlContext</code> is <code>null</code>.
     */
    public static Subject getSubject(final AccessControlContext acc) {
        return null;
    }
    
    /**
     * Perform work as a particular <code>Subject</code>.
     *
     * <p> This method first retrieves the current Thread's
     * <code>AccessControlContext</code> via
     * <code>AccessController.getContext</code>,
     * and then instantiates a new <code>AccessControlContext</code>
     * using the retrieved context along with a new
     * <code>SubjectDomainCombiner</code> (constructed using
     * the provided <code>Subject</code>).
     * Finally, this method invokes <code>AccessController.doPrivileged</code>,
     * passing it the provided <code>PrivilegedAction</code>,
     * as well as the newly constructed <code>AccessControlContext</code>.
     *
     * <p>
     *
     * @param subject the <code>Subject</code> that the specified
     *			<code>action</code> will run as.  This parameter
     *			may be <code>null</code>. <p>
     *
     * @param action the code to be run as the specified
     *			<code>Subject</code>. <p>
     *
     * @return the <code>Object</code> returned by the PrivilegedAction's
     *			<code>run</code> method.
     *
     * @exception NullPointerException if the <code>PrivilegedAction</code>
     *			is <code>null</code>. <p>
     *
     * @exception SecurityException if the caller does not have permission
     *			to invoke this method.
     */
    public static Object doAs(final Subject subject, final java.security.PrivilegedAction action) {
        return null;
    }
    
    /**
     * Perform work as a particular <code>Subject</code>.
     *
     * <p> This method first retrieves the current Thread's
     * <code>AccessControlContext</code> via
     * <code>AccessController.getContext</code>,
     * and then instantiates a new <code>AccessControlContext</code>
     * using the retrieved context along with a new
     * <code>SubjectDomainCombiner</code> (constructed using
     * the provided <code>Subject</code>).
     * Finally, this method invokes <code>AccessController.doPrivileged</code>,
     * passing it the provided <code>PrivilegedExceptionAction</code>,
     * as well as the newly constructed <code>AccessControlContext</code>.
     *
     * <p>
     *
     * @param subject the <code>Subject</code> that the specified
     *			<code>action</code> will run as.  This parameter
     *			may be <code>null</code>. <p>
     *
     * @param action the code to be run as the specified
     *			<code>Subject</code>. <p>
     *
     * @return the <code>Object</code> returned by the
     *			PrivilegedExceptionAction's <code>run</code> method.
     *
     * @exception PrivilegedActionException if the
     *			<code>PrivilegedExceptionAction.run</code>
     *			method throws a checked exception. <p>
     *
     * @exception NullPointerException if the specified
     *			<code>PrivilegedExceptionAction</code> is
     *			<code>null</code>. <p>
     *
     * @exception SecurityException if the caller does not have permission
     *			to invoke this method.
     */
    public static Object doAs(final Subject subject, final java.security.PrivilegedExceptionAction action) throws java.security.PrivilegedActionException {
        return null;
    }
    
    /**
     * Perform privileged work as a particular <code>Subject</code>.
     *
     * <p> This method behaves exactly as <code>Subject.doAs</code>,
     * except that instead of retrieving the current Thread's
     * <code>AccessControlContext</code>, it uses the provided
     * <code>AccessControlContext</code>.  If the provided
     * <code>AccessControlContext</code> is <code>null</code>,
     * this method instantiates a new <code>AccessControlContext</code>
     * with an empty collection of ProtectionDomains.
     *
     * <p>
     *
     * @param subject the <code>Subject</code> that the specified
     *			<code>action</code> will run as.  This parameter
     *			may be <code>null</code>. <p>
     *
     * @param action the code to be run as the specified
     *			<code>Subject</code>. <p>
     *
     * @param acc the <code>AccessControlContext</code> to be tied to the
     *			specified <i>subject</i> and <i>action</i>. <p>
     *
     * @return the <code>Object</code> returned by the PrivilegedAction's
     *			<code>run</code> method.
     *
     * @exception NullPointerException if the <code>PrivilegedAction</code>
     *			is <code>null</code>. <p>
     *
     * @exception SecurityException if the caller does not have permission
     *			to invoke this method.
     */
    public static Object doAsPrivileged(final Subject subject, final java.security.PrivilegedAction action, final java.security.AccessControlContext acc) {
        return null;
    }
    
    /**
     * Perform privileged work as a particular <code>Subject</code>.
     *
     * <p> This method behaves exactly as <code>Subject.doAs</code>,
     * except that instead of retrieving the current Thread's
     * <code>AccessControlContext</code>, it uses the provided
     * <code>AccessControlContext</code>.  If the provided
     * <code>AccessControlContext</code> is <code>null</code>,
     * this method instantiates a new <code>AccessControlContext</code>
     * with an empty collection of ProtectionDomains.
     *
     * <p>
     *
     * @param subject the <code>Subject</code> that the specified
     *			<code>action</code> will run as.  This parameter
     *			may be <code>null</code>. <p>
     *
     * @param action the code to be run as the specified
     *			<code>Subject</code>. <p>
     *
     * @param acc the <code>AccessControlContext</code> to be tied to the
     *			specified <i>subject</i> and <i>action</i>. <p>
     *
     * @return the <code>Object</code> returned by the
     *			PrivilegedExceptionAction's <code>run</code> method.
     *
     * @exception PrivilegedActionException if the
     *			<code>PrivilegedExceptionAction.run</code>
     *			method throws a checked exception. <p>
     *
     * @exception NullPointerException if the specified
     *			<code>PrivilegedExceptionAction</code> is
     *			<code>null</code>. <p>
     *
     * @exception SecurityException if the caller does not have permission
     *			to invoke this method.
     */
    public static Object doAsPrivileged(final Subject subject, final java.security.PrivilegedExceptionAction action, final java.security.AccessControlContext acc) throws java.security.PrivilegedActionException {
        return null;
    }
    
    
    /**
     * Return the <code>Set</code> of Principals associated with this
     * <code>Subject</code>.  Each <code>Principal</code> represents
     * an identity for this <code>Subject</code>.
     *
     * <p> The returned <code>Set</code> is backed by this Subject's
     * internal <code>Principal</code> <code>Set</code>.  Any modification
     * to the returned <code>Set</code> affects the internal
     * <code>Principal</code> <code>Set</code> as well.
     *
     * <p>
     *
     * @return	The <code>Set</code> of Principals associated with this
     *		<code>Subject</code>.
     */
    public Set getPrincipals() {
        return null;
    }
    
    /**
     * Return a <code>Set</code> of Principals associated with this
     * <code>Subject</code> that are instances or subclasses of the specified
     * <code>Class</code>.
     *
     * <p> The returned <code>Set</code> is not backed by this Subject's
     * internal <code>Principal</code> <code>Set</code>.  A new
     * <code>Set</code> is created and returned for each method invocation.
     * Modifications to the returned <code>Set</code>
     * will not affect the internal <code>Principal</code> <code>Set</code>.
     *
     * <p>
     *
     * @param c the returned <code>Set</code> of Principals will all be
     *		instances of this class.
     *
     * @return a <code>Set</code> of Principals that are instances of the
     *		specified <code>Class</code>.
     *
     * @exception NullPointerException if the specified <code>Class</code> 
     *			is <code>null</code>.
     */
    public Set getPrincipals(Class c) {
        return null;
    }
    
    /**
     * Return the <code>Set</code> of public credentials held by this
     * <code>Subject</code>.
     *
     * <p> The returned <code>Set</code> is backed by this Subject's
     * internal public Credential <code>Set</code>.  Any modification
     * to the returned <code>Set</code> affects the internal public
     * Credential <code>Set</code> as well.
     *
     * <p>
     *
     * @return	A <code>Set</code> of public credentials held by this
     *		<code>Subject</code>.
     */
    public Set getPublicCredentials() {
        return null;
    }
    
    /**
     * Return the <code>Set</code> of private credentials held by this
     * <code>Subject</code>.
     *
     * <p> The returned <code>Set</code> is backed by this Subject's
     * internal private Credential <code>Set</code>.  Any modification
     * to the returned <code>Set</code> affects the internal private
     * Credential <code>Set</code> as well.
     *
     * <p> A caller requires permissions to access the Credentials
     * in the returned <code>Set</code>, or to modify the
     * <code>Set</code> itself.  A <code>SecurityException</code>
     * is thrown if the caller does not have the proper permissions.
     * 
     * <p> While iterating through the <code>Set</code>,
     * a <code>SecurityException</code> is thrown
     * if the caller does not have permission to access a
     * particular Credential.  The <code>Iterator</code>
     * is nevertheless advanced to next element in the <code>Set</code>.
     *
     * <p>
     *
     * @return	A <code>Set</code> of private credentials held by this
     *		<code>Subject</code>.
     */
    public Set getPrivateCredentials() {
        return null;
    }
    
    /**
     * Return a <code>Set</code> of public credentials associated with this
     * <code>Subject</code> that are instances or subclasses of the specified
     * <code>Class</code>.
     *
     * <p> The returned <code>Set</code> is not backed by this Subject's
     * internal public Credential <code>Set</code>.  A new
     * <code>Set</code> is created and returned for each method invocation.
     * Modifications to the returned <code>Set</code>
     * will not affect the internal public Credential <code>Set</code>.
     *
     * <p>
     *
     * @param c the returned <code>Set</code> of public credentials will all be
     *		instances of this class.
     *
     * @return a <code>Set</code> of public credentials that are instances
     *		of the	specified <code>Class</code>.
     *
     * @exception NullPointerException if the specified <code>Class</code>
     *		is <code>null</code>.
     */
    public Set getPublicCredentials(Class c) {
        return null;
    }
    
    /**
     * Return a <code>Set</code> of private credentials associated with this
     * <code>Subject</code> that are instances or subclasses of the specified
     * <code>Class</code>. 
     *
     * <p> The caller must have permission to access all of the
     * requested Credentials, or a <code>SecurityException</code>
     * will be thrown.
     *
     * <p> The returned <code>Set</code> is not backed by this Subject's
     * internal private Credential <code>Set</code>.  A new
     * <code>Set</code> is created and returned for each method invocation.
     * Modifications to the returned <code>Set</code>
     * will not affect the internal private Credential <code>Set</code>.
     *
     * <p>
     *
     * @param c the returned <code>Set</code> of private credentials will all be
     *		instances of this class.
     *
     * @return a <code>Set</code> of private credentials that are instances
     *		of the	specified <code>Class</code>.
     *
     * @exception NullPointerException if the specified <code>Class</code>
     *		is <code>null</code>.
     */
    public Set getPrivateCredentials(Class c) {
        return null;
    }
    
    /**
     * Compares the specified Object with this <code>Subject</code>
     * for equality.  Returns true if the given object is also a Subject
     * and the two <code>Subject</code> instances are equivalent.
     * More formally, two <code>Subject</code> instances are
     * equal if their <code>Principal</code> and <code>Credential</code>
     * Sets are equal.
     *
     * <p>
     *
     * @param o Object to be compared for equality with this
     *		<code>Subject</code>.
     *
     * @return true if the specified Object is equal to this
     *		<code>Subject</code>.
     *
     * @exception SecurityException if the caller does not have permission
     *		to access the private credentials for this <code>Subject</code>,
     *		or if the caller does not have permission to access the
     *		private credentials for the provided <code>Subject</code>.
     */
    public boolean equals(Object o) {
        return false;
    }
    
    /**
     * Return the String representation of this <code>Subject</code>.
     *
     * <p>
     *
     * @return the String representation of this <code>Subject</code>.
     */
    public String toString() {
        return null;
    }
    
    
    /**
     * Returns a hashcode for this <code>Subject</code>.
     *
     * <p>
     *
     * @return a hashcode for this <code>Subject</code>.
     *
     * @exception SecurityException if the caller does not have permission
     *		to access this Subject's private credentials.
     */
    public int hashCode() {
        return 0;
    }
    
    
    
    
    
    
}
