/*
 * @(#)PrivateCredentialPermission.java	1.29 06/08/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package javax.security.auth;

import java.util.*;
import java.text.MessageFormat;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;

/**
 * This class is used to protect access to private Credentials
 * belonging to a particular <code>Subject</code>.  The <code>Subject</code>
 * is represented by a Set of Principals.
 *
 * <p> The target name of this <code>Permission</code> specifies
 * a Credential class name, and a Set of Principals.
 * The only valid value for this Permission's actions is, "read".
 * The target name must abide by the following syntax:
 *
 * <pre>
 *	CredentialClass {PrincipalClass "PrincipalName"}*
 * </pre>
 *
 * For example, the following permission grants access to the
 * com.sun.PrivateCredential owned by Subjects which have
 * a com.sun.Principal with the name, "duke".  Note that although
 * this example, as well as all the examples below, do not contain
 * Codebase, SignedBy, or Principal information in the grant statement
 * (for simplicity reasons), actual policy configurations should
 * specify that information when appropriate.
 *
 * <pre>
 *
 *    grant {
 *	permission javax.security.auth.PrivateCredentialPermission
 *		"com.sun.PrivateCredential com.sun.Principal \"duke\"",
 *		"read";
 *    };
 * </pre>
 *
 * If CredentialClass is "*", then access is granted to
 * all private Credentials belonging to the specified
 * <code>Subject</code>.
 * If "PrincipalName" is "*", then access is granted to the
 * specified Credential owned by any <code>Subject</code> that has the
 * specified <code>Principal</code> (the actual PrincipalName doesn't matter).
 * For example, the following grants access to the
 * a.b.Credential owned by any <code>Subject</code> that has
 * an a.b.Principal.
 * 
 * <pre>
 *    grant {
 *	permission javax.security.auth.PrivateCredentialPermission
 *		"a.b.Credential a.b.Principal "*"",
 *		"read";
 *    };
 * </pre>
 *
 * If both the PrincipalClass and "PrincipalName" are "*",
 * then access is granted to the specified Credential owned by
 * any <code>Subject</code>.
 * 
 * <p> In addition, the PrincipalClass/PrincipalName pairing may be repeated:
 *
 * <pre>
 *    grant {
 *	permission javax.security.auth.PrivateCredentialPermission
 *		"a.b.Credential a.b.Principal "duke" c.d.Principal "dukette"",
 *		"read";
 *    };
 * </pre>
 *
 * The above grants access to the private Credential, "a.b.Credential",
 * belonging to a <code>Subject</code> with at least two associated Principals:
 * "a.b.Principal" with the name, "duke", and "c.d.Principal", with the name,
 * "dukette".
 *
 * @version 1.29, 08/10/06
 */
public final class PrivateCredentialPermission extends Permission {
    
    
    
    
    
    
    
    /**
     * Create a new <code>PrivateCredentialPermission</code>
     * with the specified <code>credentialClass</code>
     * and an empty set of Principals.
     */
    PrivateCredentialPermission(String credentialClass, Set principals) {}
    
    /**
     * Creates a new <code>PrivateCredentialPermission</code>
     * with the specified <code>name</code>.  The <code>name</code>
     * specifies both a Credential class and a <code>Principal</code> Set.
     *
     * <p>
     *
     * @param name the name specifying the Credential class and
     *		<code>Principal</code> Set. <p>
     *
     * @param actions the actions specifying that the Credential can be read.
     *
     * @throws IllegalArgumentException if <code>name</code> does not conform
     *		to the correct syntax or if <code>actions</code> is not "read".
     */
    public PrivateCredentialPermission(String name, String actions) {}
    
    /**
     * Returns the Class name of the Credential associated with this
     * <code>PrivateCredentialPermission</code>.
     *
     * <p>
     *
     * @return the Class name of the Credential associated with this
     *		<code>PrivateCredentialPermission</code>.
     */
    public String getCredentialClass() {
        return null;
    }
    
    /**
     * Returns the <code>Principal</code> classes and names
     * associated with this <code>PrivateCredentialPermission</code>.
     * The information is returned as a two-dimensional array (array[x][y]).
     * The 'x' value corresponds to the number of <code>Principal</code>
     * class and name pairs.  When (y==0), it corresponds to
     * the <code>Principal</code> class value, and when (y==1),
     * it corresponds to the <code>Principal</code> name value.
     * For example, array[0][0] corresponds to the class name of
     * the first <code>Principal</code> in the array.  array[0][1]
     * corresponds to the <code>Principal</code> name of the
     * first <code>Principal</code> in the array.
     *
     * <p>
     *
     * @return the <code>Principal</code> class and names associated
     *		with this <code>PrivateCredentialPermission</code>.
     */
    public String[][] getPrincipals() {
        return null;
    }
    
    /**
     * Checks if this <code>PrivateCredentialPermission</code> implies
     * the specified <code>Permission</code>.
     *
     * <p>
     *
     * This method returns true if:
     * <p><ul>
     * <li> <i>p</i> is an instanceof PrivateCredentialPermission and <p>
     * <li> the target name for <i>p</i> is implied by this object's
     *		target name.  For example:
     * <pre>
     *	[* P1 "duke"] implies [a.b.Credential P1 "duke"].
     *	[C1 P1 "duke"] implies [C1 P1 "duke" P2 "dukette"].
     *	[C1 P2 "dukette"] implies [C1 P1 "duke" P2 "dukette"].
     * </pre>
     * </ul>		
     *
     * <p>
     *
     * @param p the <code>Permission</code> to check against.
     *
     * @return true if this <code>PrivateCredentialPermission</code> implies
     * the specified <code>Permission</code>, false if not.
     */
    public boolean implies(Permission p) {
        return false;
    }
    
    /**
     * Checks two <code>PrivateCredentialPermission</code> objects for
     * equality.  Checks that <i>obj</i> is a
     * <code>PrivateCredentialPermission</code>,
     * and has the same credential class as this object,
     * as well as the same Principals as this object.
     * The order of the Principals in the respective Permission's
     * target names is not relevant.
     *
     * <p>
     *
     * @param obj the object we are testing for equality with this object.
     *
     * @return true if obj is a <code>PrivateCredentialPermission</code>,
     *		has the same credential class as this object,
     *		and has the same Principals as this object.
     */
    public boolean equals(Object obj) {
        return false;
    }
    
    /**
     * Returns the hash code value for this object.
     *
     * @return a hash code value for this object.
     */
    public int hashCode() {
        return 0;
    }
    
    /**
     * Returns the "canonical string representation" of the actions.
     * This method always returns the String, "read".
     *
     * <p>
     *
     * @return the actions (always returns "read").
     */
    public String getActions() {
        return null;
    }
    
    /**
     * Return a homogeneous collection of PrivateCredentialPermissions
     * in a <code>PermissionCollection</code>.
     * No such <code>PermissionCollection</code> is defined,
     * so this method always returns <code>null</code>.
     *
     * <p>
     *
     * @return null in all cases.
     */
    public PermissionCollection newPermissionCollection() {
        return null;
    }
    
    
    
    
    
}
