/*
 * @(#)GZIPInputStream.java	1.30 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.util.zip;

import java.io.SequenceInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.EOFException;

/**
 * This class implements a stream filter for reading compressed data in
 * the GZIP format.
 *
 * @see		InflaterInputStream
 * @version 	1.22, 02/02/00
 * @author 	David Connelly
 *
 */
public class GZIPInputStream extends InflaterInputStream {
    
    /**
     * CRC-32 for uncompressed data.
     */
    protected CRC32 crc = new CRC32();
    
    /**
     * Indicates end of input stream.
     */
    protected boolean eos;
    
    
    
    /**
     * Creates a new input stream with the specified buffer size.
     * @param in the input stream
     * @param size the input buffer size
     * @exception IOException if an I/O error has occurred
     * @exception IllegalArgumentException if size is <= 0
     */
    public GZIPInputStream(InputStream in, int size) throws IOException {}
    
    /**
     * Creates a new input stream with a default buffer size.
     * @param in the input stream
     * @exception IOException if an I/O error has occurred
     */
    public GZIPInputStream(InputStream in) throws IOException {}
    
    /**
     * Reads uncompressed data into an array of bytes. Blocks until enough
     * input is available for decompression.
     * @param buf the buffer into which the data is read
     * @param off the start offset of the data
     * @param len the maximum number of bytes read
     * @return	the actual number of bytes read, or -1 if the end of the
     *		compressed input stream is reached
     * @exception IOException if an I/O error has occurred or the compressed
     *			      input data is corrupt
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        return 0;
    }
    
    /**
     * Closes the input stream.
     * @exception IOException if an I/O error has occurred
     */
    public void close() throws IOException {
        return ;
    }
    
    /**
     * GZIP header magic number.
     */
    public static final int GZIP_MAGIC = 35615;
    
    
    
    
    
    
    
    
    
    
    
    
}
