/*
 * @(#)Adler32.java	1.31 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.util.zip;

/**
 * A class that can be used to compute the Adler-32 checksum of a data
 * stream. An Adler-32 checksum is almost as reliable as a CRC-32 but
 * can be computed much faster.
 *
 * @see		Checksum
 * @version 	1.23, 05/03/00
 * @author 	David Connelly
 */
public class Adler32 implements Checksum {
    
    
    
    /**
     * Creates a new Adler32 object.
     */
    public Adler32() {}
    
    /**
     * Updates checksum with specified byte.
     * 
     * @param b an array of bytes
     */
    public void update(int b) {
        return ;
    }
    
    /**
     * Updates checksum with specified array of bytes.
     */
    public void update(byte[] b, int off, int len) {
        return ;
    }
    
    /**
     * Updates checksum with specified array of bytes.
     */
    public void update(byte[] b) {
        return ;
    }
    
    /**
     * Resets checksum to initial value.
     */
    public void reset() {
        return ;
    }
    
    /**
     * Returns checksum value.
     */
    public long getValue() {
        return 0L;
    }
    
    
}
