/*
 * @(#)DSAParameterSpec.java	1.19 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.security.spec;

import java.math.BigInteger;

/**
 * This class specifies the set of parameters used with the DSA algorithm.
 * 
 * @author Jan Luehe
 *
 * @version 1.13, 02/02/00
 *
 * @see AlgorithmParameterSpec
 *
 * @since 1.2
 */
public class DSAParameterSpec implements AlgorithmParameterSpec, java.security.interfaces.DSAParams {
    
    
    
    
    /**
     * Creates a new DSAParameterSpec with the specified parameter values.
     * 
     * @param p the prime.
     * 
     * @param q the sub-prime.
     * 
     * @param g the base.
     */
    public DSAParameterSpec(BigInteger p, BigInteger q, BigInteger g) {}
    
    /**
     * Returns the prime <code>p</code>.
     *
     * @return the prime <code>p</code>.
     */
    public BigInteger getP() {
        return null;
    }
    
    /**
     * Returns the sub-prime <code>q</code>.
     *
     * @return the sub-prime <code>q</code>.
     */
    public BigInteger getQ() {
        return null;
    }
    
    /**
     * Returns the base <code>g</code>.
     *
     * @return the base <code>g</code>.
     */
    public BigInteger getG() {
        return null;
    }
}
