/*
 * @(#)RSAPrivateKey.java	1.13 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.security.interfaces;

import java.math.BigInteger;

/**
 * The interface to an RSA private key.
 *
 * @author Jan Luehe
 *
 * @version 1.7 00/02/02
 *
 * @see RSAPrivateCrtKey
 */
public interface RSAPrivateKey extends java.security.PrivateKey, RSAKey {
    
    /**
     * Returns the private exponent.
     *
     * @return the private exponent
     */
    public BigInteger getPrivateExponent();
}
