/*
 * @(#)ProviderException.java	1.16 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.security;

/**
 * A runtime exception for Provider exceptions (such as
 * misconfiguration errors), which may be subclassed by Providers to
 * throw specialized, provider-specific runtime errors.
 *
 * @version 1.10, 00/02/02
 * @author Benjamin Renaud
 */
public class ProviderException extends RuntimeException {
    
    /**
     * Constructs a ProviderException with no detail message. A
     * detail message is a String that describes this particular
     * exception.
     */
    public ProviderException() {}
    
    /**
     * Constructs a ProviderException with the specified detail
     * message. A detail message is a String that describes this
     * particular exception.  
     *
     * @param s the detail message.  
     */
    public ProviderException(String s) {}
}
