/*
 * @(#)UnknownError.java	1.17 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown when an unknown but serious exception has occurred in the 
 * Java Virtual Machine. 
 *
 * @author unascribed
 * @version 1.10, 02/02/00
 * @since   JDK1.0
 */
public class UnknownError extends VirtualMachineError {
    
    /**
     * Constructs an <code>UnknownError</code> with no detail message. 
     */
    public UnknownError() {}
    
    /**
     * Constructs an <code>UnknownError</code> with the specified detail 
     * message. 
     *
     * @param   s   the detail message.
     */
    public UnknownError(String s) {}
}
