/*
 * @(#)NotSerializableException.java	1.18 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.io;

/**
 * Thrown when an instance is required to have a Serializable interface.
 * The serialization runtime or the class of the instance can throw
 * this exception. The argument should be the name of the class.
 *
 * @author  unascribed
 * @version 1.11, 02/02/00
 * @since   JDK1.1
 */
public class NotSerializableException extends ObjectStreamException {
    
    /**
     *
     * Constructs a NotSerializableException object with message string. 
     *
     * @param classname Class of the instance being serialized/deserialized.
     */
    public NotSerializableException(String classname) {}
    
    /**
     *  Constructs a NotSerializableException object.
     */
    public NotSerializableException() {}
}
