/*
 * @(#)FileNotFoundException.java	1.28 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.io;

/**
 * Signals that an attempt to open the file denoted by a specified pathname
 * has failed.
 *
 * <p> This exception will be thrown by the {@link FileInputStream}, {@link
 * FileOutputStream}, and {@link RandomAccessFile} (NOTE: <B>RandomAccessFile</B> 
 * is found in J2ME CDC profiles such as J2ME Foundation Profile) 
 * constructors when a file with the specified pathname does not exist.  
 * It will also be thrown by these constructors if the file does exist but 
 * for some reason is inaccessible, for example when an attempt is made to 
 * open a read-only file for writing.
 *
 * @author  unascribed
 * @version 1.20, 02/02/00
 * @since   JDK1.0
 */
public class FileNotFoundException extends IOException {
    
    /**
     * Constructs a <code>FileNotFoundException</code> with
     * <code>null</code> as its error detail message.
     */
    public FileNotFoundException() {}
    
    /**
     * Constructs a <code>FileNotFoundException</code> with the
     * specified detail message. The string <code>s</code> can be
     * retrieved later by the
     * <code>{@link java.lang.Throwable#getMessage}</code>
     * method of class <code>java.lang.Throwable</code>.
     *
     * @param   s   the detail message.
     */
    public FileNotFoundException(String s) {}
    
    /**
     * Constructs a <code>FileNotFoundException</code> with a detail message
     * consisting of the given pathname string followed by the given reason
     * string.  If the <code>reason</code> argument is <code>null</code> then
     * it will be omitted.  This private constructor is invoked only by native
     * I/O methods.
     *
     * @since 1.2
     */
    private FileNotFoundException(String path, String reason) {}
}
