/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import sun.security.util.Debug;
import sun.security.util.ResourcesMgr;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private ModuleInfo[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class[] PARAMS = new Class[0];
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");

    private void init(String string) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("createLoginContext." + string));
        }
        if (string == null) {
            throw new LoginException(ResourcesMgr.getString("Invalid null input: name"));
        }
        if (this.config == null) {
            this.config = (Configuration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(string)) == null) {
            if (securityManager != null) {
                securityManager.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(OTHER)) == null) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("No LoginModules configured for name"));
                Object[] objectArray = new Object[]{string};
                throw new LoginException(messageFormat.format(objectArray));
            }
        }
        this.moduleStack = new ModuleInfo[appConfigurationEntryArray.length];
        for (int i = 0; i < appConfigurationEntryArray.length; ++i) {
            this.moduleStack[i] = new ModuleInfo(new AppConfigurationEntry(appConfigurationEntryArray[i].getLoginModuleName(), appConfigurationEntryArray[i].getControlFlag(), appConfigurationEntryArray[i].getOptions()), null);
        }
        this.contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void loadDefaultCallbackHandler() throws LoginException {
        try {
            final ClassLoader classLoader = this.contextClassLoader;
            this.callbackHandler = (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string = Security.getProperty(LoginContext.DEFAULT_HANDLER);
                    if (string == null || string.length() == 0) {
                        return null;
                    }
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    return clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new LoginException(privilegedActionException.getException().toString());
        }
        if (this.callbackHandler != null) {
            this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), this.callbackHandler);
        }
    }

    public LoginContext(String string) throws LoginException {
        this.init(string);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this.init(string);
        if (subject == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null Subject provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.init(string);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invokeModule(LOGIN_METHOD);
            this.invokeModule(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException loginException) {
            try {
                this.invokeModule(ABORT_METHOD);
            }
            catch (LoginException loginException2) {
                throw loginException;
            }
            throw loginException;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException(ResourcesMgr.getString("null subject - logout called before login"));
        }
        this.invokeModule(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void throwException(LoginException loginException, LoginException loginException2) throws LoginException {
        LoginException loginException3 = loginException != null ? loginException : loginException2;
        throw loginException3;
    }

    private void invokeModule(String string) throws LoginException {
        try {
            final String string2 = string;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    LoginContext.this.invoke(string2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private void invoke(String string) throws LoginException {
        Object object = null;
        Object object2 = null;
        boolean bl = false;
        for (int i = 0; i < this.moduleStack.length; ++i) {
            Object object3;
            Object object4;
            try {
                int n = 0;
                object4 = null;
                if (this.moduleStack[i].module != null) {
                    object4 = this.moduleStack[i].module.getClass().getMethods();
                } else {
                    object3 = Class.forName(this.moduleStack[i].entry.getLoginModuleName(), true, this.contextClassLoader);
                    Constructor constructor = ((Class)object3).getConstructor(PARAMS);
                    Object[] objectArray = new Object[]{};
                    this.moduleStack[i].module = constructor.newInstance(objectArray);
                    object4 = this.moduleStack[i].module.getClass().getMethods();
                    for (n = 0; n < ((Method[])object4).length && !object4[n].getName().equals(INIT_METHOD); ++n) {
                    }
                    Object[] objectArray2 = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[i].entry.getOptions()};
                    object4[n].invoke(this.moduleStack[i].module, objectArray2);
                }
                for (n = 0; n < ((Method[])object4).length && !object4[n].getName().equals(string); ++n) {
                }
                object3 = new Object[0];
                boolean bl2 = (Boolean)object4[n].invoke(this.moduleStack[i].module, (Object[])object3);
                if (bl2) {
                    if (!string.equals(ABORT_METHOD) && !string.equals(LOGOUT_METHOD) && this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && object2 == null) {
                        if (debug != null) {
                            debug.println(string + " SUFFICIENT success");
                        }
                        return;
                    }
                    if (debug != null) {
                        debug.println(string + " success");
                    }
                    bl = true;
                    continue;
                }
                if (debug == null) continue;
                debug.println(string + " ignored");
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object4 = new MessageFormat(ResourcesMgr.getString("unable to instantiate LoginModule, module, because it does not provide a no-argument constructor"));
                object3 = new Object[]{this.moduleStack[i].entry.getLoginModuleName()};
                throw new LoginException(object4.format(object3));
            }
            catch (InstantiationException instantiationException) {
                throw new LoginException(ResourcesMgr.getString("unable to instantiate LoginModule: ") + instantiationException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new LoginException(ResourcesMgr.getString("unable to find LoginModule class: ") + classNotFoundException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LoginException(ResourcesMgr.getString("unable to access LoginModule: ") + illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof LoginException) {
                    object4 = (LoginException)invocationTargetException.getCause();
                } else {
                    object3 = new StringWriter();
                    invocationTargetException.getCause().printStackTrace(new PrintWriter((Writer)object3));
                    ((StringWriter)object3).flush();
                    object4 = new LoginException(((StringWriter)object3).toString());
                }
                if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                    if (debug != null) {
                        debug.println(string + " REQUISITE failure");
                    }
                    if (string.equals(ABORT_METHOD) || string.equals(LOGOUT_METHOD)) {
                        if (object2 != null) continue;
                        object2 = object4;
                        continue;
                    }
                    this.throwException((LoginException)object2, (LoginException)object4);
                    continue;
                }
                if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    if (debug != null) {
                        debug.println(string + " REQUIRED failure");
                    }
                    if (object2 != null) continue;
                    object2 = object4;
                    continue;
                }
                if (debug != null) {
                    debug.println(string + " OPTIONAL failure");
                }
                if (object != null) continue;
                object = object4;
            }
        }
        if (object2 != null) {
            this.throwException((LoginException)object2, null);
        } else if (!bl && object != null) {
            this.throwException((LoginException)object, null);
        } else if (!bl) {
            this.throwException(new LoginException(ResourcesMgr.getString("Login Failure: all modules ignored")), null);
        } else {
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry appConfigurationEntry, Object object) {
            this.entry = appConfigurationEntry;
            this.module = object;
        }
    }

    private static class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext accessControlContext, CallbackHandler callbackHandler) {
            this.acc = accessControlContext;
            this.ch = callbackHandler;
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            try {
                final Callback[] callbackArray2 = callbackArray;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, UnsupportedCallbackException {
                        SecureCallbackHandler.this.ch.handle(callbackArray2);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (UnsupportedCallbackException)privilegedActionException.getException();
            }
        }
    }
}

