/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_n;
import com.sun.net.ssl.internal.ssl.JSA_RSAPrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import sun.security.util.Debug;

public class JSA_RSAnonCRTPrivateKey
extends JS_PrivateKey
implements RSAPrivateKey,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6438884938615559810L;

    JSA_RSAnonCRTPrivateKey(JSA_RSAPrivateKey jSA_RSAPrivateKey) {
        this.thePrivateKey = jSA_RSAPrivateKey.thePrivateKey;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS8";
    }

    public byte[] getEncoded() {
        try {
            byte[][] byArray = this.thePrivateKey.a("RSAPrivateKeyBER");
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            return byArray[0];
        }
        catch (SunJSSE_n sunJSSE_n) {
            return null;
        }
    }

    public BigInteger getModulus() {
        BigInteger bigInteger = null;
        try {
            byte[][] byArray = this.thePrivateKey.a("RSAPrivateKey");
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            bigInteger = new BigInteger(1, byArray[0]);
            for (int i = 0; i < byArray[1].length; ++i) {
                byArray[1][i] = 0;
            }
        }
        catch (SunJSSE_n sunJSSE_n) {
            bigInteger = null;
        }
        return bigInteger;
    }

    public BigInteger getPrivateExponent() {
        BigInteger bigInteger = null;
        try {
            byte[][] byArray = this.thePrivateKey.a("RSAPrivateKey");
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            bigInteger = new BigInteger(1, byArray[1]);
            for (int i = 0; i < byArray[1].length; ++i) {
                byArray[1][i] = 0;
            }
        }
        catch (SunJSSE_n sunJSSE_n) {
            bigInteger = null;
        }
        return bigInteger;
    }

    public int hashCode() {
        return this.getModulus().hashCode() + this.getPrivateExponent().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RSAPrivateKey) {
            BigInteger bigInteger = this.getModulus();
            if (!bigInteger.equals(((RSAPrivateKey)object).getModulus())) {
                return false;
            }
            bigInteger = this.getPrivateExponent();
            return bigInteger.equals(((RSAPrivateKey)object).getPrivateExponent());
        }
        return false;
    }

    private static String a(BigInteger bigInteger) {
        return Debug.toHexString(bigInteger);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SunJSSE RSA private key:\n  private exponent:\n");
        stringBuffer.append(JSA_RSAnonCRTPrivateKey.a(this.getPrivateExponent()));
        stringBuffer.append("\n  modulus:\n");
        stringBuffer.append(JSA_RSAnonCRTPrivateKey.a(this.getModulus()));
        return stringBuffer.toString();
    }

    void b() {
    }
}

