/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_bh;
import COM.rsa.jsafe.SunJSSE_bj;
import COM.rsa.jsafe.SunJSSE_n;
import com.sun.net.ssl.internal.ssl.JSA_RSAPrivateKey;
import com.sun.net.ssl.internal.ssl.JSA_RSAPublicKey;
import com.sun.net.ssl.internal.ssl.JS_ConvertBigInteger;
import com.sun.net.ssl.internal.ssl.JS_KeyFactory;
import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PublicKey;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class JSA_RSAKeyFactory
extends JS_KeyFactory
implements Cloneable,
Serializable {
    public JSA_RSAKeyFactory() {
        super("RSA", "RSA");
    }

    protected byte[][] getPublicKeyData(KeySpec keySpec, StringBuffer stringBuffer) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            stringBuffer.setLength(0);
            stringBuffer.insert(0, "RSAPublicKey");
            BigInteger bigInteger = ((RSAPublicKeySpec)keySpec).getModulus();
            BigInteger bigInteger2 = ((RSAPublicKeySpec)keySpec).getPublicExponent();
            byte[] byArray = JS_ConvertBigInteger.toByteArray(bigInteger);
            byte[] byArray2 = JS_ConvertBigInteger.toByteArray(bigInteger2);
            byte[][] byArrayArray = new byte[][]{byArray, byArray2};
            return byArrayArray;
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            stringBuffer.setLength(0);
            stringBuffer.insert(0, "RSAPublicKeyBER");
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        throw new InvalidKeySpecException("Key spec not RSA.");
    }

    protected byte[][] getPrivateKeyData(KeySpec keySpec, StringBuffer stringBuffer) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            stringBuffer.setLength(0);
            stringBuffer.insert(0, "RSAPrivateKeyCRT");
            BigInteger bigInteger = ((RSAPrivateCrtKeySpec)keySpec).getModulus();
            BigInteger bigInteger2 = ((RSAPrivateCrtKeySpec)keySpec).getPublicExponent();
            BigInteger bigInteger3 = ((RSAPrivateCrtKeySpec)keySpec).getPrivateExponent();
            BigInteger bigInteger4 = ((RSAPrivateCrtKeySpec)keySpec).getPrimeP();
            BigInteger bigInteger5 = ((RSAPrivateCrtKeySpec)keySpec).getPrimeQ();
            BigInteger bigInteger6 = ((RSAPrivateCrtKeySpec)keySpec).getPrimeExponentP();
            BigInteger bigInteger7 = ((RSAPrivateCrtKeySpec)keySpec).getPrimeExponentQ();
            BigInteger bigInteger8 = ((RSAPrivateCrtKeySpec)keySpec).getCrtCoefficient();
            byte[] byArray = JS_ConvertBigInteger.toByteArray(bigInteger);
            byte[] byArray2 = JS_ConvertBigInteger.toByteArray(bigInteger2);
            byte[] byArray3 = JS_ConvertBigInteger.toByteArray(bigInteger3);
            byte[] byArray4 = JS_ConvertBigInteger.toByteArray(bigInteger4);
            byte[] byArray5 = JS_ConvertBigInteger.toByteArray(bigInteger5);
            byte[] byArray6 = JS_ConvertBigInteger.toByteArray(bigInteger6);
            byte[] byArray7 = JS_ConvertBigInteger.toByteArray(bigInteger7);
            byte[] byArray8 = JS_ConvertBigInteger.toByteArray(bigInteger8);
            byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8};
            return byArrayArray;
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            stringBuffer.setLength(0);
            stringBuffer.insert(0, "RSAPrivateKey");
            BigInteger bigInteger = ((RSAPrivateKeySpec)keySpec).getModulus();
            BigInteger bigInteger9 = ((RSAPrivateKeySpec)keySpec).getPrivateExponent();
            byte[] byArray = JS_ConvertBigInteger.toByteArray(bigInteger);
            byte[] byArray9 = JS_ConvertBigInteger.toByteArray(bigInteger9);
            byte[][] byArrayArray = new byte[][]{byArray, byArray9};
            return byArrayArray;
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            stringBuffer.setLength(0);
            stringBuffer.insert(0, "RSAPrivateKeyBER");
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        throw new InvalidKeySpecException("Key spec not RSA.");
    }

    public PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey privateKey = super.engineGeneratePrivate(keySpec);
        if (privateKey instanceof JSA_RSAPrivateKey) {
            privateKey = ((JSA_RSAPrivateKey)privateKey).c();
        }
        return privateKey;
    }

    public KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key.getAlgorithm().compareTo("RSA") != 0) {
            throw new InvalidKeySpecException("Key spec does not match the key.");
        }
        try {
            String string = clazz.getName();
            if (string.compareTo("java.security.spec.RSAPublicKeySpec") == 0) {
                if (!(key instanceof JS_PublicKey)) {
                    throw new InvalidKeySpecException("Key spec does not match the key.");
                }
                SunJSSE_bh sunJSSE_bh = ((JS_PublicKey)key).a();
                byte[][] byArray = sunJSSE_bh.a("RSAPublicKey");
                sunJSSE_bh.a();
                BigInteger bigInteger = new BigInteger(1, byArray[0]);
                BigInteger bigInteger2 = new BigInteger(1, byArray[1]);
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
                return rSAPublicKeySpec;
            }
            if (string.compareTo("java.security.spec.X509EncodedKeySpec") == 0) {
                if (!(key instanceof JS_PublicKey)) {
                    throw new InvalidKeySpecException("Key spec does not match the key.");
                }
                SunJSSE_bh sunJSSE_bh = ((JS_PublicKey)key).a();
                byte[][] byArray = sunJSSE_bh.a("RSAPublicKeyBER");
                sunJSSE_bh.a();
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray[0]);
                return x509EncodedKeySpec;
            }
            if (string.compareTo("java.security.spec.RSAPrivateKeySpec") == 0) {
                if (!(key instanceof JS_PrivateKey)) {
                    throw new InvalidKeySpecException("Key spec does not match the key.");
                }
                SunJSSE_bj sunJSSE_bj = ((JS_PrivateKey)key).a();
                byte[][] byArray = sunJSSE_bj.a("RSAPrivateKey");
                sunJSSE_bj.a();
                BigInteger bigInteger = new BigInteger(1, byArray[0]);
                BigInteger bigInteger3 = new BigInteger(1, byArray[1]);
                for (int i = 0; i < byArray[1].length; ++i) {
                    byArray[1][i] = 0;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger3);
                return rSAPrivateKeySpec;
            }
            if (string.compareTo("java.security.spec.RSAPrivateCrtKeySpec") == 0) {
                if (!(key instanceof JS_PrivateKey)) {
                    throw new InvalidKeySpecException("Key spec does not match the key.");
                }
                SunJSSE_bj sunJSSE_bj = ((JS_PrivateKey)key).a();
                byte[][] byArray = sunJSSE_bj.a("RSAPrivateKeyCRT");
                sunJSSE_bj.a();
                BigInteger bigInteger = new BigInteger(1, byArray[0]);
                BigInteger bigInteger4 = new BigInteger(1, byArray[1]);
                BigInteger bigInteger5 = new BigInteger(1, byArray[2]);
                BigInteger bigInteger6 = new BigInteger(1, byArray[3]);
                BigInteger bigInteger7 = new BigInteger(1, byArray[4]);
                BigInteger bigInteger8 = new BigInteger(1, byArray[5]);
                BigInteger bigInteger9 = new BigInteger(1, byArray[6]);
                BigInteger bigInteger10 = new BigInteger(1, byArray[7]);
                for (int i = 2; i <= 7; ++i) {
                    for (int j = 0; j < byArray[i].length; ++j) {
                        byArray[i][j] = 0;
                    }
                }
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9, bigInteger10);
                return rSAPrivateCrtKeySpec;
            }
            if (string.compareTo("java.security.spec.PKCS8EncodedKeySpec") == 0) {
                if (!(key instanceof JS_PrivateKey)) {
                    throw new InvalidKeySpecException("Key spec does not match the key.");
                }
                SunJSSE_bj sunJSSE_bj = ((JS_PrivateKey)key).a();
                byte[][] byArray = sunJSSE_bj.a("RSAPrivateKeyBER");
                sunJSSE_bj.a();
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray[0]);
                for (int i = 0; i < byArray[0].length; ++i) {
                    byArray[0][i] = 0;
                }
                return pKCS8EncodedKeySpec;
            }
            throw new InvalidKeySpecException("Unknown key spec.");
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new InvalidKeySpecException("Unknown key spec.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
    }

    public Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof RSAPublicKey) {
                if (key instanceof JSA_RSAPublicKey) {
                    return (JSA_RSAPublicKey)((JSA_RSAPublicKey)key).clone();
                }
                BigInteger bigInteger = ((RSAPublicKey)key).getModulus();
                BigInteger bigInteger2 = ((RSAPublicKey)key).getPublicExponent();
                byte[] byArray = JS_ConvertBigInteger.toByteArray(bigInteger);
                byte[] byArray2 = JS_ConvertBigInteger.toByteArray(bigInteger2);
                byte[][] byArrayArray = new byte[][]{byArray, byArray2};
                SunJSSE_bh sunJSSE_bh = SunJSSE_bh.a("RSA", "Java");
                sunJSSE_bh.a("RSAPublicKey", byArrayArray);
                JS_PublicKey jS_PublicKey = JS_PublicKey.getInstance(sunJSSE_bh);
                sunJSSE_bh.a();
                return jS_PublicKey;
            }
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof JSA_RSAPrivateKey) {
                    return (JSA_RSAPrivateKey)((JSA_RSAPrivateKey)key).clone();
                }
                BigInteger bigInteger = ((RSAPrivateCrtKey)key).getModulus();
                BigInteger bigInteger3 = ((RSAPrivateCrtKey)key).getPublicExponent();
                BigInteger bigInteger4 = ((RSAPrivateCrtKey)key).getPrivateExponent();
                BigInteger bigInteger5 = ((RSAPrivateCrtKey)key).getPrimeP();
                BigInteger bigInteger6 = ((RSAPrivateCrtKey)key).getPrimeQ();
                BigInteger bigInteger7 = ((RSAPrivateCrtKey)key).getPrimeExponentP();
                BigInteger bigInteger8 = ((RSAPrivateCrtKey)key).getPrimeExponentQ();
                BigInteger bigInteger9 = ((RSAPrivateCrtKey)key).getCrtCoefficient();
                byte[] byArray = JS_ConvertBigInteger.toByteArray(bigInteger);
                byte[] byArray3 = JS_ConvertBigInteger.toByteArray(bigInteger3);
                byte[] byArray4 = JS_ConvertBigInteger.toByteArray(bigInteger4);
                byte[] byArray5 = JS_ConvertBigInteger.toByteArray(bigInteger5);
                byte[] byArray6 = JS_ConvertBigInteger.toByteArray(bigInteger6);
                byte[] byArray7 = JS_ConvertBigInteger.toByteArray(bigInteger7);
                byte[] byArray8 = JS_ConvertBigInteger.toByteArray(bigInteger8);
                byte[] byArray9 = JS_ConvertBigInteger.toByteArray(bigInteger9);
                byte[][] byArrayArray = new byte[][]{byArray, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, byArray9};
                SunJSSE_bj sunJSSE_bj = SunJSSE_bj.a("RSA", "Java");
                sunJSSE_bj.a("RSAPrivateKeyCRT", byArrayArray);
                for (int i = 2; i <= 7; ++i) {
                    for (int j = 0; j < byArrayArray[i].length; ++j) {
                        byArrayArray[i][j] = 0;
                    }
                }
                JS_PrivateKey jS_PrivateKey = JS_PrivateKey.getInstance(sunJSSE_bj);
                sunJSSE_bj.a();
                return jS_PrivateKey;
            }
            if (key instanceof RSAPrivateKey) {
                if (key instanceof JSA_RSAPrivateKey) {
                    return (JSA_RSAPrivateKey)((JSA_RSAPrivateKey)key).clone();
                }
                BigInteger bigInteger = ((RSAPrivateKey)key).getModulus();
                BigInteger bigInteger10 = ((RSAPrivateKey)key).getPrivateExponent();
                byte[] byArray = JS_ConvertBigInteger.toByteArray(bigInteger);
                byte[] byArray10 = JS_ConvertBigInteger.toByteArray(bigInteger10);
                byte[][] byArrayArray = new byte[][]{byArray, byArray10};
                SunJSSE_bj sunJSSE_bj = SunJSSE_bj.a("RSA", "Java");
                sunJSSE_bj.a("RSAPrivateKey", byArrayArray);
                for (int i = 0; i < byArray10.length; ++i) {
                    byArray10[i] = 0;
                }
                JS_PrivateKey jS_PrivateKey = JS_PrivateKey.getInstance(sunJSSE_bj);
                sunJSSE_bj.a();
                return jS_PrivateKey;
            }
            throw new InvalidKeyException("Key not RSA.");
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new InvalidKeyException("Unknown key.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidKeyException("Unknown key.");
        }
    }

    void a() {
        super.a();
    }

    protected void finalize() {
        this.a();
    }
}

