/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import com.sun.util.logging.Formatter;
import com.sun.util.logging.Handler;
import com.sun.util.logging.LogManager;
import com.sun.util.logging.LogRecord;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class XMLFormatter
extends Formatter {
    private LogManager manager = LogManager.getLogManager();
    private DateFormat df = null;
    static final String format = "yyyy-MM-dd'T'hh:mm:ss";

    private void a2(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    private void appendISO8601(StringBuffer stringBuffer, long l) {
        Date date = new Date(l);
        if (this.df == null) {
            this.df = new SimpleDateFormat(format);
        }
        stringBuffer.append(this.df.format(date));
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public String format(LogRecord logRecord) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<record>\n");
        stringBuffer.append("  <date>");
        this.appendISO8601(stringBuffer, logRecord.getMillis());
        stringBuffer.append("</date>\n");
        stringBuffer.append("  <millis>");
        stringBuffer.append(logRecord.getMillis());
        stringBuffer.append("</millis>\n");
        stringBuffer.append("  <sequence>");
        stringBuffer.append(logRecord.getSequenceNumber());
        stringBuffer.append("</sequence>\n");
        String string = logRecord.getLoggerName();
        if (string != null) {
            stringBuffer.append("  <logger>");
            this.escape(stringBuffer, string);
            stringBuffer.append("</logger>\n");
        }
        stringBuffer.append("  <level>");
        this.escape(stringBuffer, logRecord.getLevel().toString());
        stringBuffer.append("</level>\n");
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append("  <class>");
            this.escape(stringBuffer, logRecord.getSourceClassName());
            stringBuffer.append("</class>\n");
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append("  <method>");
            this.escape(stringBuffer, logRecord.getSourceMethodName());
            stringBuffer.append("</method>\n");
        }
        stringBuffer.append("  <thread>");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append("</thread>\n");
        if (logRecord.getMessage() != null) {
            object = this.formatMessage(logRecord);
            stringBuffer.append("  <message>");
            this.escape(stringBuffer, (String)object);
            stringBuffer.append("</message>");
            stringBuffer.append("\n");
        }
        object = logRecord.getResourceBundle();
        try {
            if (object != null && ((ResourceBundle)object).getString(logRecord.getMessage()) != null) {
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, logRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, logRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null && objectArray.length != 0 && logRecord.getMessage().indexOf("{") == -1) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("  <param>");
                try {
                    this.escape(stringBuffer, objectArray[i].toString());
                }
                catch (Exception exception) {
                    stringBuffer.append("???");
                }
                stringBuffer.append("</param>\n");
            }
        }
        if (logRecord.getThrown() != null) {
            Throwable throwable = logRecord.getThrown();
            stringBuffer.append("  <exception>\n");
            stringBuffer.append("    <message>");
            this.escape(stringBuffer, throwable.toString());
            stringBuffer.append("</message>\n");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                stringBuffer.append("    <frame>\n");
                stringBuffer.append("      <class>");
                this.escape(stringBuffer, stackTraceElement.getClassName());
                stringBuffer.append("</class>\n");
                stringBuffer.append("      <method>");
                this.escape(stringBuffer, stackTraceElement.getMethodName());
                stringBuffer.append("</method>\n");
                if (stackTraceElement.getLineNumber() >= 0) {
                    stringBuffer.append("      <line>");
                    stringBuffer.append(stackTraceElement.getLineNumber());
                    stringBuffer.append("</line>\n");
                }
                stringBuffer.append("    </frame>\n");
            }
            stringBuffer.append("  </exception>\n");
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"");
        String string = handler != null ? handler.getEncoding() : null;
        if (string == null) {
            // empty if block
        }
        stringBuffer.append(" encoding=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        stringBuffer.append(" standalone=\"no\"?>\n");
        stringBuffer.append("<!DOCTYPE log SYSTEM \"logger.dtd\">\n");
        stringBuffer.append("<log>\n");
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "</log>\n";
    }
}

