/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import com.sun.util.logging.Formatter;
import com.sun.util.logging.Handler;
import com.sun.util.logging.Level;
import com.sun.util.logging.LogManager;
import com.sun.util.logging.LogRecord;
import com.sun.util.logging.SimpleFormatter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class StreamHandler
extends Handler {
    private LogManager manager = LogManager.getLogManager();
    private OutputStream output;
    private boolean doneHeader;
    private Writer writer;

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.INFO));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public StreamHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        this.sealed = false;
        this.configure();
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
        this.sealed = true;
    }

    protected synchronized void setOutputStream(OutputStream outputStream) throws SecurityException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.flushAndClose();
        this.output = outputStream;
        this.doneHeader = false;
        String string = this.getEncoding();
        if (string == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("Unexpected exception " + unsupportedEncodingException);
            }
        }
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        if (this.output == null) {
            return;
        }
        this.flush();
        this.writer = string == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, string);
    }

    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(string);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (this.writer == null || logRecord == null) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    public synchronized void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 2);
            }
        }
    }

    private synchronized void flushAndClose() throws SecurityException {
        this.checkAccess();
        if (this.writer != null) {
            try {
                if (!this.doneHeader) {
                    this.writer.write(this.getFormatter().getHead(this));
                    this.doneHeader = true;
                }
                this.writer.write(this.getFormatter().getTail(this));
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 3);
            }
            this.writer = null;
            this.output = null;
        }
    }

    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

