/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import com.sun.util.logging.Level;
import com.sun.util.logging.LogManager;
import com.sun.util.logging.Logger;
import com.sun.util.logging.LoggingMXBean;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

class Logging
implements LoggingMXBean {
    private static LogManager logManager = LogManager.getLogManager();
    private static String EMPTY_STRING = "";

    Logging() {
    }

    public List getLoggerNames() {
        Enumeration enumeration = logManager.getLoggerNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return arrayList;
    }

    public String getLoggerLevel(String string) {
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            return null;
        }
        Level level = logger.getLevel();
        if (level == null) {
            return EMPTY_STRING;
        }
        return level.getName();
    }

    public void setLoggerLevel(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("loggerName is null");
        }
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            throw new IllegalArgumentException("Logger " + string + "does not exist");
        }
        Level level = null;
        if (string2 != null) {
            level = Level.parse(string2);
        }
        logger.setLevel(level);
    }

    public String getParentLoggerName(String string) {
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            return null;
        }
        Logger logger2 = logger.getParent();
        if (logger2 == null) {
            return EMPTY_STRING;
        }
        return logger2.getName();
    }
}

