/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    private static ArrayList known = new ArrayList();
    private static String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, defaultBundle);
    public static final Level SEVERE = new Level("SEVERE", 1000, defaultBundle);
    public static final Level WARNING = new Level("WARNING", 900, defaultBundle);
    public static final Level INFO = new Level("INFO", 800, defaultBundle);
    public static final Level CONFIG = new Level("CONFIG", 700, defaultBundle);
    public static final Level FINE = new Level("FINE", 500, defaultBundle);
    public static final Level FINER = new Level("FINER", 400, defaultBundle);
    public static final Level FINEST = new Level("FINEST", 300, defaultBundle);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, defaultBundle);
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String string, int n) {
        this(string, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String string, int n, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.value = n;
        this.resourceBundleName = string2;
        Class clazz = Level.class;
        synchronized (clazz) {
            known.add(this);
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            return resourceBundle.getString(this.name);
        }
        catch (Exception exception) {
            return this.name;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class clazz = Level.class;
        synchronized (clazz) {
            for (int i = 0; i < known.size(); ++i) {
                Level level = (Level)known.get(i);
                if (!this.name.equals(level.name) || this.value != level.value || this.resourceBundleName != level.resourceBundleName && (this.resourceBundleName == null || !this.resourceBundleName.equals(level.resourceBundleName))) continue;
                return level;
            }
            known.add(this);
            return this;
        }
    }

    public static synchronized Level parse(String string) throws IllegalArgumentException {
        Level level;
        int n;
        string.length();
        for (n = 0; n < known.size(); ++n) {
            level = (Level)known.get(n);
            if (!string.equals(level.name)) continue;
            return level;
        }
        try {
            n = Integer.parseInt(string);
            for (int i = 0; i < known.size(); ++i) {
                Level level2 = (Level)known.get(i);
                if (level2.value != n) continue;
                return level2;
            }
            return new Level(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            for (int i = 0; i < known.size(); ++i) {
                level = (Level)known.get(i);
                if (!string.equals(level.getLocalizedName())) continue;
                return level;
            }
            throw new IllegalArgumentException("Bad level \"" + string + "\"");
        }
    }

    public boolean equals(Object object) {
        try {
            Level level = (Level)object;
            return level.value == this.value;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }
}

