/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import com.sun.util.logging.Level;
import com.sun.util.logging.LogManager;
import com.sun.util.logging.LogRecord;
import com.sun.util.logging.StreamHandler;
import com.sun.util.logging.XMLFormatter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;

public class AsyncSocketHandler
extends StreamHandler {
    private Socket sock;
    private String host;
    private int port;
    private String portProperty;
    private boolean closed = false;
    protected static int prio = 5;
    protected static final LoggerThread logger = new LoggerThread();
    protected static final int TIMEOUT = 10000;
    protected static final LinkedList queue = new LinkedList();

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.port = logManager.getIntProperty(string + ".port", 0);
        this.host = logManager.getStringProperty(string + ".host", null);
        prio = logManager.getIntProperty(string + ".priority", 5);
    }

    public AsyncSocketHandler() throws IOException {
        this.sealed = false;
        this.configure();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            System.err.println("SocketHandler: connect failed to " + this.host + ":" + this.port);
            throw iOException;
        }
        this.sealed = true;
    }

    public AsyncSocketHandler(String string, int n, int n2) throws IOException {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.port = n;
        this.host = string;
        prio = n2;
        this.connect();
    }

    private void connect() throws IOException {
        if (this.port == 0) {
            throw new IllegalArgumentException("Bad port: " + this.port);
        }
        if (this.host == null) {
            throw new IllegalArgumentException("Null host name: " + this.host);
        }
        this.sock = new Socket(this.host, this.port);
        OutputStream outputStream = this.sock.getOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        this.setOutputStream(bufferedOutputStream);
    }

    public synchronized void close() throws SecurityException {
        super.close();
        this.closed = true;
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        AsyncSocketHandler.logger.run = false;
        this.sock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        LogEntry logEntry = new LogEntry(logRecord, this);
        LinkedList linkedList = queue;
        synchronized (linkedList) {
            queue.addLast(logEntry);
            queue.notifyAll();
        }
    }

    protected void publishImpl(LogRecord logRecord) {
        super.publish(logRecord);
        super.flush();
    }

    static {
        logger.start();
    }

    protected static class LogEntry {
        private LogRecord record;
        private AsyncSocketHandler handler;

        public LogEntry(LogRecord logRecord, AsyncSocketHandler asyncSocketHandler) {
            this.record = logRecord;
            this.handler = asyncSocketHandler;
        }

        public boolean flush() {
            if (this.handler.closed) {
                return false;
            }
            this.handler.publishImpl(this.record);
            return true;
        }
    }

    protected static class LoggerThread
    extends Thread {
        protected boolean run = true;
        protected int currentPrio = prio;

        public LoggerThread() {
            this.setDaemon(true);
            this.setName("AsyncSocketHandlerWriter-" + System.identityHashCode(this));
            this.setPriority(prio);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.run) {
                if (this.currentPrio != prio) {
                    this.setPriority(prio);
                    this.currentPrio = prio;
                }
                try {
                    LogEntry logEntry;
                    LinkedList linkedList = queue;
                    synchronized (linkedList) {
                        if (queue.isEmpty()) {
                            queue.wait(10000L);
                        }
                        logEntry = !queue.isEmpty() ? (LogEntry)queue.removeFirst() : null;
                    }
                    if (logEntry == null) continue;
                    logEntry.flush();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

