/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import com.sun.util.logging.Filter;
import com.sun.util.logging.Level;
import com.sun.util.logging.LogManager;
import com.sun.util.logging.LogRecord;
import com.sun.util.logging.SelfClosingOutputStream;
import com.sun.util.logging.StreamHandler;
import com.sun.util.logging.XMLFormatter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;

public class ServerSocketHandler
extends StreamHandler {
    private static final int offvalue = Level.OFF.intValue();
    private Socket sock = null;
    private int port = -1;
    private int buffersize = 2;
    protected boolean closed = false;
    protected static int prio = 5;
    protected LoggerThread logger = null;
    protected ServerSocketListenerThread sslt = null;
    protected static final int TIMEOUT = 10000;
    protected final LinkedList queue = new LinkedList();

    private synchronized void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.port = logManager.getIntProperty(string + ".port", 0);
        prio = logManager.getIntProperty(string + ".priority", 5);
        this.buffersize = logManager.getIntProperty(string + ".buffersize", 30);
    }

    public ServerSocketHandler() throws IOException {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.sslt = new ServerSocketListenerThread(this, this.port, prio);
        try {
            this.sslt.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            System.err.println("Unable to start ServerSocketHandler Thread!");
        }
    }

    public ServerSocketHandler(int n, int n2) throws IOException {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.port = n;
        prio = n2;
        this.sslt = new ServerSocketListenerThread(this, n, n2);
        try {
            this.sslt.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            System.err.println("Unable to start ServerSocketHandler Thread!");
        }
    }

    private synchronized void setStream(Socket socket, LoggerThread loggerThread) throws IOException {
        this.sock = socket;
        this.logger = loggerThread;
        OutputStream outputStream = this.sock.getOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        SelfClosingOutputStream selfClosingOutputStream = new SelfClosingOutputStream(bufferedOutputStream, this.sock);
        this.setOutputStream(selfClosingOutputStream);
        this.closed = false;
    }

    public synchronized void close() throws SecurityException {
        super.close();
        this.closed = true;
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.logger.run = false;
        this.sock = null;
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (logRecord == null) {
            return false;
        }
        int n = this.getLevel().intValue();
        if (logRecord.getLevel().intValue() < n || n == offvalue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publish(LogRecord logRecord) {
        boolean bl = false;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        logRecord.getSourceMethodName();
        LogEntry logEntry = new LogEntry(logRecord, this);
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            while (this.queue.size() >= this.buffersize) {
                this.queue.removeFirst();
                bl = true;
            }
            if (bl) {
                LogEntry logEntry2 = (LogEntry)this.queue.removeFirst();
                LogRecord logRecord2 = new LogRecord(Level.FINE, "Some log information lost");
                logRecord2.setLoggerName("com.sun.util.logging.ServerSocketHandler");
                logRecord2.setMillis(logEntry2.getRecordMillis());
                LogEntry logEntry3 = new LogEntry(logRecord2, this);
                this.queue.addFirst(logEntry3);
            }
            this.queue.addLast(logEntry);
            this.queue.notifyAll();
        }
    }

    protected void publishImpl(LogRecord logRecord) {
        if (this.sock.isClosed()) {
            this.closed = true;
            this.logger.run = false;
        } else {
            super.publish(logRecord);
            super.flush();
        }
    }

    protected class LogEntry {
        private LogRecord record;
        private ServerSocketHandler handler;

        public LogEntry(LogRecord logRecord, ServerSocketHandler serverSocketHandler2) {
            this.record = logRecord;
            this.handler = serverSocketHandler2;
        }

        public long getRecordMillis() {
            return this.record.getMillis();
        }

        public boolean flush() {
            if (this.handler.closed) {
                return false;
            }
            this.handler.publishImpl(this.record);
            return true;
        }
    }

    protected class LoggerThread
    extends Thread {
        protected boolean run = true;
        protected int currentPrio = 5;
        protected ServerSocketHandler ssHdlr = null;

        public LoggerThread(ServerSocketHandler serverSocketHandler2, int n) {
            this.setDaemon(true);
            this.setName("ServerSocketHandlerWriter-" + System.identityHashCode(this));
            this.setPriority(n);
            this.currentPrio = n;
            this.ssHdlr = serverSocketHandler2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.run) {
                try {
                    LogEntry logEntry;
                    LinkedList linkedList = this.ssHdlr.queue;
                    synchronized (linkedList) {
                        if (this.ssHdlr.queue.isEmpty()) {
                            this.ssHdlr.queue.wait(10000L);
                        }
                        logEntry = !this.ssHdlr.queue.isEmpty() ? (LogEntry)this.ssHdlr.queue.removeFirst() : null;
                    }
                    if (logEntry == null) continue;
                    logEntry.flush();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopRunningAndDie() {
            this.run = false;
            LinkedList linkedList = this.ssHdlr.queue;
            synchronized (linkedList) {
                this.ssHdlr.queue.notifyAll();
            }
            if (this.isAlive()) {
                try {
                    this.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }
    }

    protected class ServerSocketListenerThread
    extends Thread {
        protected boolean run = true;
        protected int port = -1;
        protected int prio = 5;
        protected ServerSocketHandler ssHdlr = null;
        protected LoggerThread loggerthread = null;

        public ServerSocketListenerThread(ServerSocketHandler serverSocketHandler2, int n, int n2) {
            this.setDaemon(true);
            this.setName("ServerSocketListenerThread-" + System.identityHashCode(this));
            this.port = n;
            this.prio = n2;
            this.ssHdlr = serverSocketHandler2;
        }

        public void run() {
            ServerSocket serverSocket = null;
            Socket socket = null;
            if (this.port < 0 || this.port > 65535) {
                return;
            }
            while (this.run) {
                if (serverSocket == null) {
                    try {
                        serverSocket = new ServerSocket(this.port);
                        System.err.println("LogHandler waiting for incoming connection on port " + serverSocket.getLocalPort());
                    }
                    catch (IOException iOException) {
                        System.err.println("ServerSocketHandler.LoggerThread: Unable to create ServerSocket on port " + this.port + ". Stopping!");
                        this.run = false;
                    }
                }
                try {
                    socket = serverSocket.accept();
                }
                catch (IOException iOException) {
                    System.err.println("Error in ServerSocket.accept()");
                    this.run = false;
                }
                if (this.loggerthread != null) {
                    this.loggerthread.stopRunningAndDie();
                }
                this.loggerthread = new LoggerThread(this.ssHdlr, this.prio);
                try {
                    this.ssHdlr.setStream(socket, this.loggerthread);
                }
                catch (IOException iOException) {
                    System.err.println("ServerSocketHandler: Error opening new OutputStream");
                }
                try {
                    this.loggerthread.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    System.err.println("ServerSocketHandler: trying to restart a LoggerThread");
                }
            }
        }
    }
}

