/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC0;

import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC0.JDBCResultSetMetaData;
import SQLite.JDBC0.JDBCStatement;
import SQLite.JDBC0.TableResultX;
import SQLite.Shell;
import SQLite.StringEncoder;
import SQLite.TableResult;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;

public class JDBCResultSet
implements ResultSet {
    private int row;
    protected TableResult tr;
    private JDBCStatement s;
    private JDBCResultSetMetaData md;
    private String lastg;
    private int updatable;
    private String uptable;
    private String[] pkcols;
    private int[] pkcoli;
    private static final int UPD_UNKNOWN = -1;
    private static final int UPD_NO = 0;
    private static final int UPD_INS = 1;
    private static final int UPD_INSUPDDEL = 2;
    private boolean oninsrow;
    private String[] rowbuf;
    private static final boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCResultSet(TableResult tableResult, JDBCStatement jDBCStatement) {
        this.tr = tableResult;
        this.s = jDBCStatement;
        this.md = null;
        this.lastg = null;
        this.row = -1;
        this.updatable = -1;
        this.oninsrow = false;
        this.rowbuf = null;
    }

    public boolean isUpdatable() throws SQLException {
        if (this.updatable == -1) {
            try {
                JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
                HashSet<String> hashSet = new HashSet<String>();
                String string = null;
                for (int i = 1; i <= this.tr.ncolumns; ++i) {
                    string = jDBCResultSetMetaData.getTableName(i);
                    hashSet.add(string);
                }
                if (hashSet.size() > 1 || string == null) {
                    this.updatable = 0;
                    throw new SQLException("view or join");
                }
                this.updatable = 1;
                this.uptable = string;
                JDBCResultSet jDBCResultSet = (JDBCResultSet)this.s.conn.getMetaData().getPrimaryKeys(null, null, this.uptable);
                if (jDBCResultSet.tr.nrows > 0) {
                    boolean bl = false;
                    this.pkcols = new String[jDBCResultSet.tr.nrows];
                    this.pkcoli = new int[jDBCResultSet.tr.nrows];
                    for (int i = 0; i < jDBCResultSet.tr.nrows; ++i) {
                        String[] stringArray = (String[])jDBCResultSet.tr.rows.elementAt(i);
                        this.pkcols[i] = stringArray[3];
                        try {
                            this.pkcoli[i] = this.findColumn(this.pkcols[i]) - 1;
                            continue;
                        }
                        catch (SQLException sQLException) {
                            bl = true;
                        }
                    }
                    if (!bl) {
                        this.updatable = 2;
                    }
                }
                jDBCResultSet.close();
            }
            catch (SQLException sQLException) {
                this.updatable = 0;
            }
        }
        if (this.updatable < 1) {
            throw new SQLException("result set not updatable");
        }
        return true;
    }

    public void fillRowbuf() throws SQLException {
        if (this.rowbuf == null) {
            if (this.row < 0) {
                throw new SQLException("cursor outside of result set");
            }
            this.rowbuf = new String[this.tr.ncolumns];
            System.arraycopy((String[])this.tr.rows.elementAt(this.row), 0, this.rowbuf, 0, this.tr.ncolumns);
        }
    }

    public boolean next() throws SQLException {
        if (this.tr == null) {
            return false;
        }
        ++this.row;
        return this.row < this.tr.nrows;
    }

    public int findColumn(String string) throws SQLException {
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        return jDBCResultSetMetaData.findColByName(string);
    }

    public int getRow() throws SQLException {
        if (this.tr == null) {
            throw new SQLException("no rows");
        }
        return this.row + 1;
    }

    public boolean previous() throws SQLException {
        if (this.tr == null) {
            throw new SQLException("result set already closed");
        }
        if (this.row >= 0) {
            --this.row;
        }
        return this.row >= 0;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (n < 0) {
            n = this.tr.nrows + 1 + n;
        }
        if (--n < 0 || n > this.tr.nrows) {
            return false;
        }
        this.row = n;
        return true;
    }

    public boolean relative(int n) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (this.row + n < 0 || this.row + n >= this.tr.nrows) {
            return false;
        }
        this.row += n;
        return true;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("not supported");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n != 1) {
            throw new SQLException("not supported");
        }
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public String getString(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        return this.lastg;
    }

    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    public int getInt(int n) throws SQLException {
        Integer n2 = this.internalGetInt(n);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    private Integer internalGetInt(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Integer.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) == 1 || Boolean.valueOf(this.getString(n)) != false;
    }

    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.md == null) {
            this.md = new JDBCResultSetMetaData(this);
        }
        return this.md;
    }

    public short getShort(int n) throws SQLException {
        Short s = this.internalGetShort(n);
        if (s != null) {
            return s;
        }
        return 0;
    }

    private Short internalGetShort(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Short.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    public Time getTime(int n) throws SQLException {
        return this.internalGetTime(n, null);
    }

    /*
     * Loose catch block
     */
    private Time internalGetTime(int n, Calendar calendar) throws SQLException {
        block8: {
            if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
                throw new SQLException("column " + n + " not found");
            }
            String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = stringArray[n - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Time(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception exception) {
                return Time.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception exception) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Time.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            return new Time(Database.long_from_julian(this.lastg));
        }
    }

    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.internalGetTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.internalGetTimestamp(n, null);
    }

    /*
     * Loose catch block
     */
    private Timestamp internalGetTimestamp(int n, Calendar calendar) throws SQLException {
        block8: {
            if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
                throw new SQLException("column " + n + " not found");
            }
            String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = stringArray[n - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Timestamp(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception exception) {
                return Timestamp.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception exception) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Timestamp.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            return new Timestamp(Database.long_from_julian(this.lastg));
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.internalGetTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    public Date getDate(int n) throws SQLException {
        return this.internalGetDate(n, null);
    }

    /*
     * Loose catch block
     */
    private Date internalGetDate(int n, Calendar calendar) throws SQLException {
        block8: {
            if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
                throw new SQLException("column " + n + " not found");
            }
            String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = stringArray[n - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Date(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception exception) {
                return Date.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception exception) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Date.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            return new Date(Database.long_from_julian(this.lastg));
        }
    }

    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.internalGetDate(n, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    public double getDouble(int n) throws SQLException {
        Double d = this.internalGetDouble(n);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private Double internalGetDouble(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Double.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    public float getFloat(int n) throws SQLException {
        Float f = this.internalGetFloat(n);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    private Float internalGetFloat(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Float.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    public long getLong(int n) throws SQLException {
        Long l = this.internalGetLong(n);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    private Long internalGetLong(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Long.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        byte[] byArray = this.getBytes(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public byte getByte(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        byte[] byArray = null;
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        if (this.lastg != null) {
            byArray = StringEncoder.decode(this.lastg);
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public Object getObject(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        Object object = this.lastg;
        if (this.tr instanceof TableResultX) {
            switch (((TableResultX)this.tr).sql_type[n - 1]) {
                case 5: {
                    object = this.internalGetShort(n);
                    break;
                }
                case 4: {
                    object = this.internalGetInt(n);
                    break;
                }
                case 8: {
                    object = this.internalGetDouble(n);
                    break;
                }
                case 6: {
                    object = this.internalGetFloat(n);
                    break;
                }
                case -5: {
                    object = this.internalGetLong(n);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.getBytes(n);
                    break;
                }
                case 0: {
                    object = null;
                }
            }
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            char[] cArray = string.toCharArray();
            return new CharArrayReader(cArray);
        }
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        String string2 = this.getString(string);
        if (string2 != null) {
            char[] cArray = string2.toCharArray();
            return new CharArrayReader(cArray);
        }
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean wasNull() throws SQLException {
        return this.lastg == null;
    }

    public void clearWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean isFirst() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row < 0;
    }

    public void beforeFirst() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = -1;
    }

    public boolean first() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = 0;
        return true;
    }

    public boolean isAfterLast() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row >= this.tr.nrows;
    }

    public void afterLast() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = this.tr.nrows;
    }

    public boolean isLast() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == this.tr.nrows - 1;
    }

    public boolean last() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = this.tr.nrows - 1;
        return true;
    }

    public int getType() throws SQLException {
        return 1005;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void insertRow() throws SQLException {
        int n;
        this.isUpdatable();
        if (!this.oninsrow || this.rowbuf == null) {
            throw new SQLException("no insert data provided");
        }
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(Shell.sql_quote_dbl(this.uptable));
        stringBuffer.append("(");
        for (n = 0; n < this.tr.ncolumns; ++n) {
            stringBuffer.append(Shell.sql_quote_dbl(jDBCResultSetMetaData.getColumnName(n + 1)));
            if (n >= this.tr.ncolumns - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") VALUES(");
        for (n = 0; n < this.tr.ncolumns; ++n) {
            stringBuffer.append(nullrepl ? "'%q'" : "%Q");
            if (n >= this.tr.ncolumns - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        try {
            this.s.conn.db.exec(stringBuffer.toString(), null, this.rowbuf);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        this.tr.newrow(this.rowbuf);
        this.rowbuf = null;
        this.oninsrow = false;
        this.last();
    }

    public void updateRow() throws SQLException {
        int n;
        this.isUpdatable();
        if (this.rowbuf == null) {
            throw new SQLException("no update data provided");
        }
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        String[] stringArray2 = new String[this.tr.ncolumns + this.pkcols.length];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(Shell.sql_quote_dbl(this.uptable));
        stringBuffer.append(" SET ");
        for (n = 0; n < this.tr.ncolumns; ++n) {
            stringBuffer.append(Shell.sql_quote_dbl(jDBCResultSetMetaData.getColumnName(n + 1)));
            stringBuffer.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (n < this.tr.ncolumns - 1) {
                stringBuffer.append(",");
            }
            stringArray2[n] = this.rowbuf[n];
        }
        stringBuffer.append(" WHERE ");
        int n2 = 0;
        while (n2 < this.pkcols.length) {
            stringBuffer.append(Shell.sql_quote_dbl(this.pkcols[n2]));
            stringBuffer.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (n2 < this.pkcols.length - 1) {
                stringBuffer.append(" AND ");
            }
            stringArray2[n] = stringArray[this.pkcoli[n2]];
            ++n2;
            ++n;
        }
        try {
            this.s.conn.db.exec(stringBuffer.toString(), null, stringArray2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        System.arraycopy(this.rowbuf, 0, stringArray, 0, this.rowbuf.length);
        this.rowbuf = null;
    }

    public void deleteRow() throws SQLException {
        this.isUpdatable();
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        this.fillRowbuf();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(Shell.sql_quote_dbl(this.uptable));
        stringBuffer.append(" WHERE ");
        String[] stringArray = new String[this.pkcols.length];
        for (int i = 0; i < this.pkcols.length; ++i) {
            stringBuffer.append(Shell.sql_quote_dbl(this.pkcols[i]));
            stringBuffer.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.pkcols.length - 1) {
                stringBuffer.append(" AND ");
            }
            stringArray[i] = this.rowbuf[this.pkcoli[i]];
        }
        try {
            this.s.conn.db.exec(stringBuffer.toString(), null, stringArray);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        this.rowbuf = null;
    }

    public void refreshRow() throws SQLException {
        this.isUpdatable();
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < this.tr.ncolumns; ++i) {
            stringBuffer.append(Shell.sql_quote_dbl(jDBCResultSetMetaData.getColumnName(i + 1)));
            if (i >= this.tr.ncolumns - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(Shell.sql_quote_dbl(this.uptable));
        stringBuffer.append(" WHERE ");
        String[] stringArray2 = new String[this.pkcols.length];
        for (int i = 0; i < this.pkcols.length; ++i) {
            stringBuffer.append(Shell.sql_quote_dbl(this.pkcols[i]));
            stringBuffer.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.pkcols.length - 1) {
                stringBuffer.append(" AND ");
            }
            stringArray2[i] = stringArray[this.pkcoli[i]];
        }
        TableResult tableResult = null;
        try {
            tableResult = this.s.conn.db.get_table(stringBuffer.toString(), stringArray2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        if (tableResult.nrows != 1) {
            throw new SQLException("wrong size of result set");
        }
        this.rowbuf = null;
        this.tr.rows.setElementAt(tableResult.rows.elementAt(0), this.row);
    }

    public void cancelRowUpdates() throws SQLException {
        this.rowbuf = null;
    }

    public void moveToInsertRow() throws SQLException {
        this.isUpdatable();
        if (!this.oninsrow) {
            this.oninsrow = true;
            this.rowbuf = new String[this.tr.nrows];
        }
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.oninsrow) {
            this.oninsrow = false;
            this.rowbuf = null;
        }
    }

    public void updateNull(int n) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = null;
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateString(n, bl ? "1" : "0");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateShort(int n, short s) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Short.toString(s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Integer.toString(n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Long.toString(l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Float.toString(f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Double.toString(d);
    }

    public void updateString(int n, String string) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = string;
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = this.s.conn.db.is3() ? StringEncoder.encodeX(byArray) : StringEncoder.encode(byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = date.toString();
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = time.toString();
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = timestamp.toString();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateString(n, object.toString());
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateString(n, object.toString());
    }

    public void updateNull(String string) throws SQLException {
        int n = this.findColumn(string);
        this.updateNull(n);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        int n = this.findColumn(string);
        this.updateBoolean(n, bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateShort(String string, short s) throws SQLException {
        int n = this.findColumn(string);
        this.updateShort(n, s);
    }

    public void updateInt(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateInt(n2, n);
    }

    public void updateLong(String string, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateLong(n, l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        int n = this.findColumn(string);
        this.updateFloat(n, f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        int n = this.findColumn(string);
        this.updateDouble(n, d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateString(String string, String string2) throws SQLException {
        int n = this.findColumn(string);
        this.updateString(n, string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        int n = this.findColumn(string);
        this.updateBytes(n, byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        int n = this.findColumn(string);
        this.updateDate(n, date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        int n = this.findColumn(string);
        this.updateTime(n, time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n = this.findColumn(string);
        this.updateTimestamp(n, timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateObject(String string, Object object) throws SQLException {
        int n = this.findColumn(string);
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateObject(n2, object, n);
    }

    public Statement getStatement() throws SQLException {
        if (this.s == null) {
            throw new SQLException("stale result set");
        }
        return this.s;
    }

    public void close() throws SQLException {
        this.s = null;
        this.tr = null;
        this.lastg = null;
        this.oninsrow = false;
        this.rowbuf = null;
        this.row = -1;
    }

    public URL getURL(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        URL uRL = null;
        if (this.lastg == null) {
            return uRL;
        }
        try {
            uRL = new URL(this.lastg);
        }
        catch (java.lang.Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public URL getURL(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getURL(n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("not supported");
    }
}

