/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.misc.iso8601;

import oracle.adfmf.misc.iso8601.Format;
import oracle.adfmf.misc.iso8601.FormatEntry;
import oracle.adfmf.misc.iso8601.FormatEntryFrac;
import oracle.adfmf.misc.iso8601.FormatEntryTz;

public class Parser {
    private static final long SECOND_FRAC = 1000L;
    private static final long MINUTE_FRAC = 60000L;
    private static final long HOUR_FRAC = 3600000L;
    private static final FormatEntry DATE_0;
    private static final FormatEntry DATE_1;
    private static final FormatEntry TIME_0;
    private static final FormatEntry TIME_1;
    private static final FormatEntry TIME_2;
    private static final FormatEntry TIME_3;
    private static final FormatEntry TIME_4;
    public static final FormatEntry[] s_dateEntry;
    public static final FormatEntry[] s_timeEntry;
    public static final long[] s_fracMult;
    public static final FormatEntry[] s_dateTzEntry;
    public static final FormatEntry[] s_timeTzEntry;
    public static final FormatEntry[] s_timeFracEntry;
    public static final FormatEntry[] s_timeFracTzEntry;

    private Parser() {
    }

    public static Format getDateFormat(String string, boolean bl) {
        Format format = Parser._getDateOrTimeFormat(s_dateEntry, string);
        if (format == null && bl) {
            format = Parser._getDateOrTimeFormat(s_dateTzEntry, string);
        }
        return format;
    }

    public static Format getTimeFormat(String string) {
        Format format = Parser._getDateOrTimeFormat(s_timeEntry, string);
        if (format == null) {
            format = Parser._getDateOrTimeFormat(s_timeTzEntry, string);
        }
        if (format == null) {
            format = Parser._getDateOrTimeFormat(s_timeFracEntry, string);
        }
        if (format == null) {
            format = Parser._getDateOrTimeFormat(s_timeFracTzEntry, string);
        }
        return format;
    }

    private static Format _getDateOrTimeFormat(FormatEntry[] formatEntryArray, String string) {
        int n = formatEntryArray.length;
        for (int i = 0; i < n; ++i) {
            FormatEntry formatEntry = formatEntryArray[i];
            Format format = formatEntry.getFormat(string);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    static {
        int n;
        DATE_0 = new FormatEntry("Date0", "[0-9]{4}-[0-9]{2}-[0-9]{2}", "yyyy-MM-dd");
        DATE_1 = new FormatEntry("Date1", "[0-9]{4}[0-9]{2}[0-9]{2}", "yyyyMMdd");
        TIME_0 = new FormatEntry("Time0", "[0-9]{2}:[0-9]{2}:[0-9]{2}", "HH:mm:ss");
        TIME_1 = new FormatEntry("Time1", "[0-9]{2}[0-9]{2}[0-9]{2}", "HHmmss");
        TIME_2 = new FormatEntry("Time2", "[0-9]{2}:[0-9]{2}", "HH:mm");
        TIME_3 = new FormatEntry("Time3", "[0-9]{2}[0-9]{2}", "HHmm");
        TIME_4 = new FormatEntry("Time4", "[0-9]{2}", "HH");
        s_dateEntry = new FormatEntry[]{DATE_0, DATE_1};
        s_timeEntry = new FormatEntry[]{TIME_0, TIME_1, TIME_2, TIME_3, TIME_4};
        s_fracMult = new long[]{1000L, 1000L, 60000L, 60000L, 3600000L};
        int n2 = s_dateEntry.length;
        s_dateTzEntry = new FormatEntry[n2];
        for (n = 0; n < n2; ++n) {
            Parser.s_dateTzEntry[n] = new FormatEntryTz(s_dateEntry[n]);
        }
        n = s_timeEntry.length;
        s_timeTzEntry = new FormatEntry[n];
        s_timeFracEntry = new FormatEntry[n];
        s_timeFracTzEntry = new FormatEntry[n];
        for (int i = 0; i < n; ++i) {
            Parser.s_timeTzEntry[i] = new FormatEntryTz(s_timeEntry[i]);
            Parser.s_timeFracEntry[i] = new FormatEntryFrac(s_timeEntry[i], s_fracMult[i]);
            Parser.s_timeFracTzEntry[i] = new FormatEntryTz(s_timeFracEntry[i]);
        }
    }
}

