/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.misc.iso8601;

import oracle.adfmf.misc.iso8601.Format;
import oracle.adfmf.misc.iso8601.FormatEntry;
import oracle.adfmf.misc.iso8601.NestedFormatEntry;
import oracle.adfmf.util.regex.Matcher;

class FormatEntryTz
extends FormatEntry {
    private static final String TZ_Z_NAME = "Z";
    private static final String TZ_Z_REGEX = "(Z)";
    private static final String TZ_HH_NAME = "HH";
    private static final String TZ_HH_REGEX = "([+-][0-9]{2})";
    private static final String TZ_HHmm_NAME = "HHmm";
    private static final String TZ_HHmm_REGEX = "([+-][0-9]{2})[:]{0,1}([0-9]{2})";
    private final FormatEntryTzImpl[] _entries;

    FormatEntryTz(FormatEntry formatEntry) {
        this(formatEntry, false);
    }

    FormatEntryTz(FormatEntry formatEntry, boolean bl) {
        this._entries = new FormatEntryTzImpl[]{new FormatEntryTzImpl(formatEntry, TZ_Z_NAME, TZ_Z_REGEX, bl), new FormatEntryTzImpl(formatEntry, TZ_HHmm_NAME, TZ_HHmm_REGEX, bl), new FormatEntryTzImpl(formatEntry, TZ_HH_NAME, TZ_HH_REGEX, bl)};
    }

    public Format getFormat(String string) {
        int n = this._entries.length;
        for (int i = 0; i < n; ++i) {
            Format format = this._entries[i].getFormat(string);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    static class FormatEntryTzImpl
    extends NestedFormatEntry {
        FormatEntryTzImpl(FormatEntry formatEntry, String string, String string2, boolean bl) {
            super(formatEntry, formatEntry.name + "_" + string, "(" + formatEntry.pattern + ")" + string2, formatEntry.format + 'Z', bl);
        }

        protected int getCaptureGroupOffset() {
            throw new UnsupportedOperationException("getGroupOffset is unsupported on timezone entries");
        }

        protected Format getFormat(String string) {
            Format format;
            Matcher matcher = this.getMatcher(string);
            if (!matcher.matches()) {
                return null;
            }
            int n = this.getEntryCaptureGroupOffset() + 1;
            String string2 = matcher.group(1);
            String string3 = "+00";
            String string4 = "00";
            String string5 = matcher.group(n + 1);
            if (string5 != null && string5.length() == 3) {
                string3 = string5;
            }
            if (matcher.groupCount() == n + 2 && (string5 = matcher.group(n + 2)) != null && string5.length() == 2) {
                string4 = string5;
            }
            if ((format = this.entry.getFormat(string2)) == null) {
                return null;
            }
            return new Format(format.value + string3 + string4, format.pattern + 'Z', format.ticks);
        }
    }
}

