/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.misc;

import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.adfmf.misc.ConverterException;
import oracle.adfmf.misc.ISO8601DateTimeUtil;

public class Converter {
    private Converter() {
    }

    protected static Boolean coerceToBoolean(Object object) {
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new ConverterException(0, object, object.getClass(), Boolean.class);
    }

    protected static Character coerceToCharacter(Object object) {
        if (object == null || "".equals(object)) {
            return new Character('\u0000');
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Number) {
            return new Character((char)((Number)object).shortValue());
        }
        if (object instanceof String) {
            return new Character(((String)object).charAt(0));
        }
        throw new ConverterException(0, object, object.getClass(), Character.class);
    }

    protected static BigDecimal coerceToBigDecimal(Object object) {
        if (object == null || "".equals(object)) {
            return BigDecimal.valueOf(0L);
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), BigDecimal.class);
            }
        }
        if (object instanceof Character) {
            return new BigDecimal((double)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), BigDecimal.class);
    }

    protected static BigInteger coerceToBigInteger(Object object) {
        if (object == null || "".equals(object)) {
            return BigInteger.valueOf(0L);
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toBigInteger();
        }
        if (object instanceof Number) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (object instanceof String) {
            try {
                return new BigInteger((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), BigInteger.class);
            }
        }
        if (object instanceof Character) {
            return BigInteger.valueOf((short)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), BigInteger.class);
    }

    protected static Double coerceToDouble(Object object) {
        if (object == null || "".equals(object)) {
            return new Double(0.0);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), Double.class);
            }
        }
        if (object instanceof Character) {
            return new Double((short)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), Double.class);
    }

    protected static Float coerceToFloat(Object object) {
        if (object == null || "".equals(object)) {
            return new Float(0.0f);
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Number) {
            return new Float(((Number)object).floatValue());
        }
        if (object instanceof String) {
            try {
                return Float.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), Float.class);
            }
        }
        if (object instanceof Character) {
            return new Float((short)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), Float.class);
    }

    protected static Long coerceToLong(Object object) {
        if (object == null || "".equals(object)) {
            return new Long(0L);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return new Long(((Number)object).longValue());
        }
        if (object instanceof String) {
            try {
                return Long.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), Long.class);
            }
        }
        if (object instanceof Character) {
            return new Long((short)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), Long.class);
    }

    protected static Integer coerceToInteger(Object object) {
        if (object == null || "".equals(object)) {
            return new Integer(0);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return new Integer(((Number)object).intValue());
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), Integer.class);
            }
        }
        if (object instanceof Character) {
            return new Integer((short)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), Integer.class);
    }

    protected static Short coerceToShort(Object object) {
        if (object == null || "".equals(object)) {
            return new Short(0);
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Number) {
            return new Short(((Number)object).shortValue());
        }
        if (object instanceof String) {
            try {
                return Short.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), Short.class);
            }
        }
        if (object instanceof Character) {
            return new Short((short)((Character)object).charValue());
        }
        throw new ConverterException(0, object, object.getClass(), Short.class);
    }

    protected static Byte coerceToByte(Object object) {
        if (object == null || "".equals(object)) {
            return new Byte(0);
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Number) {
            return new Byte(((Number)object).byteValue());
        }
        if (object instanceof String) {
            try {
                return Byte.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConverterException(1, object, object.getClass(), Byte.class);
            }
        }
        if (object instanceof Character) {
            return new Byte(new Short((short)((Character)object).charValue()).byteValue());
        }
        throw new ConverterException(0, object, object.getClass(), Byte.class);
    }

    protected static String coerceToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static Object coerceToType(Object object, Class clazz) {
        if (clazz == String.class) {
            return Converter.coerceToString(object);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Converter.coerceToLong(object);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Converter.coerceToDouble(object);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Converter.coerceToBoolean(object);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Converter.coerceToInteger(object);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Converter.coerceToFloat(object);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Converter.coerceToShort(object);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Converter.coerceToByte(object);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Converter.coerceToCharacter(object);
        }
        if (clazz == BigDecimal.class) {
            return Converter.coerceToBigDecimal(object);
        }
        if (clazz == BigInteger.class) {
            return Converter.coerceToBigInteger(object);
        }
        if (object instanceof String && ISO8601DateTimeUtil.isDateType(clazz)) {
            try {
                return ISO8601DateTimeUtil.coerceToDate(clazz, (String)object);
            }
            catch (Exception exception) {
                throw new ConverterException(0, object, object.getClass(), clazz, exception);
            }
        }
        if (object == null || object.getClass() == clazz || clazz.isInstance(object)) {
            return object;
        }
        throw new ConverterException(0, object, object.getClass(), clazz);
    }

    public static Object convert(Object object, Class clazz) throws ConverterException {
        return Converter.coerceToType(object, clazz);
    }
}

