/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import javax.el.ELContext;
import javax.el.ELException;

public class AstUnary
extends AstRightValue {
    public static final Operator EMPTY = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object) {
            return new Boolean(BooleanOperations.empty(typeConverter, object));
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NEG = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object) {
            return NumberOperations.neg(typeConverter, object);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object) {
            return new Boolean((Boolean)typeConverter.convert(object, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AstUnary.class$("java.lang.Boolean")) : class$java$lang$Boolean) == false);
        }

        public String toString() {
            return "!";
        }
    };
    private final Operator operator;
    private final AstNode child;
    static /* synthetic */ Class class$java$lang$Boolean;

    public AstUnary(AstNode astNode, Operator operator) {
        this.child = astNode;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext eLContext) throws ELException {
        return this.operator.eval(bindings, eLContext, this.child);
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuffer stringBuffer, Bindings bindings) {
        stringBuffer.append(this.operator);
        stringBuffer.append(' ');
        this.child.appendStructure(stringBuffer, bindings);
    }

    public int getCardinality() {
        return 1;
    }

    public Node getChild(int n) {
        return n == 0 ? this.child : null;
    }

    public static abstract class SimpleOperator
    implements Operator {
        public Object eval(Bindings bindings, ELContext eLContext, AstNode astNode) {
            return this.apply(bindings, astNode.eval(bindings, eLContext));
        }

        protected abstract Object apply(TypeConverter var1, Object var2);
    }

    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3);
    }
}

