/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;

public class AstFunction
extends AstRightValue
implements FunctionNode {
    private final int index;
    private final String name;
    private final AstParameters params;
    private final boolean varargs;

    public AstFunction(String string, int n, AstParameters astParameters) {
        this(string, n, astParameters, false);
    }

    public AstFunction(String string, int n, AstParameters astParameters, boolean bl) {
        this.name = string;
        this.index = n;
        this.params = astParameters;
        this.varargs = bl;
    }

    protected Object invoke(Bindings bindings, ELContext eLContext, Object object, Method method) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = null;
        if (classArray.length > 0) {
            objectArray = new Object[classArray.length];
            if (this.varargs) {
                // empty if block
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = this.getParam(i).eval(bindings, eLContext);
                if (object2 == null && !classArray[i].isPrimitive()) continue;
                objectArray[i] = bindings.convert(object2, classArray[i]);
            }
        }
        return method.invoke(object, objectArray);
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        Method method = bindings.getFunction(this.index);
        try {
            return this.invoke(bindings, eLContext, null, method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.function.access", new Object[]{this.name}), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.function.invocation", new Object[]{this.name}), invocationTargetException.getCause());
        }
    }

    public String toString() {
        return this.name;
    }

    public void appendStructure(StringBuffer stringBuffer, Bindings bindings) {
        stringBuffer.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        this.params.appendStructure(stringBuffer, bindings);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public int getParamCount() {
        return this.params.getCardinality();
    }

    protected AstNode getParam(int n) {
        return (AstNode)this.params.getChild(n);
    }

    public int getCardinality() {
        return 1;
    }

    public Node getChild(int n) {
        return n == 0 ? this.params : null;
    }
}

