/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.ValueReference;

public final class AstEval
extends AstNode {
    private final AstNode child;
    private final boolean deferred;

    public AstEval(AstNode astNode, boolean bl) {
        this.child = astNode;
        this.deferred = bl;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean isLeftValue() {
        return ((ExpressionNode)this.getChild(0)).isLeftValue();
    }

    public boolean isMethodInvocation() {
        return ((ExpressionNode)this.getChild(0)).isMethodInvocation();
    }

    public ValueReference getValueReference(Bindings bindings, ELContext eLContext) {
        return this.child.getValueReference(bindings, eLContext);
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        return this.child.eval(bindings, eLContext);
    }

    public String toString() {
        return (this.deferred ? "#" : "$") + "{...}";
    }

    public void appendStructure(StringBuffer stringBuffer, Bindings bindings) {
        stringBuffer.append(this.deferred ? "#{" : "${");
        this.child.appendStructure(stringBuffer, bindings);
        stringBuffer.append("}");
    }

    public MethodInfo getMethodInfo(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray) {
        return this.child.getMethodInfo(bindings, eLContext, clazz, classArray);
    }

    public Object invoke(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray, Object[] objectArray) {
        return this.child.invoke(bindings, eLContext, clazz, classArray, objectArray);
    }

    public Class getType(Bindings bindings, ELContext eLContext) {
        return this.child.getType(bindings, eLContext);
    }

    public boolean isLiteralText() {
        return this.child.isLiteralText();
    }

    public boolean isReadOnly(Bindings bindings, ELContext eLContext) {
        return this.child.isReadOnly(bindings, eLContext);
    }

    public void setValue(Bindings bindings, ELContext eLContext, Object object) {
        this.child.setValue(bindings, eLContext, object);
    }

    public int getCardinality() {
        return 1;
    }

    public Node getChild(int n) {
        return n == 0 ? this.child : null;
    }
}

