/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import com.sun.util.logging.Level;
import java.util.List;
import java.util.Vector;
import oracle.adfmf.util.AttributeInfo;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class GenericVirtualType
implements GenericType {
    public static GenericVirtualType PLACEHOLDER_INSTANCE = new GenericVirtualType();
    protected boolean complex = false;
    protected String namespace = null;
    protected String name = null;
    protected Vector attribute = null;
    protected Vector attributeInfo = new Vector();
    protected GenericType parent = null;

    public GenericVirtualType() {
        this.attribute = new Vector();
    }

    public GenericVirtualType(String string, String string2) {
        this();
        this.namespace = string;
        this.name = string2;
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "GenericVirtualType", "Creating {0}", new Object[]{this.toString()});
        }
    }

    public void defineAttribute(String string, String string2, Class clazz) {
        this.defineAttribute(string, string2, clazz, null);
    }

    public void defineAttribute(String string, String string2, Class clazz, Object object) {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.namespace = string == null ? "" : string;
        attributeInfo.name = string2;
        attributeInfo.type = clazz;
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "defineAttribute", "Registering attribute: {0}, {1}", new Object[]{attributeInfo.namespace, attributeInfo.name});
        }
        this.attributeInfo.add(attributeInfo);
        this.attribute.add(object);
        if (object instanceof GenericType) {
            ((GenericType)object).setParent(this);
            this.complex = true;
        }
    }

    public void defineAttribute(GenericType genericType) {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.namespace = genericType.getNamespace();
        attributeInfo.name = genericType.getName();
        Object object = attributeInfo.type = GenericType.class;
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "defineAttribute", "Registering attribute: {0}, {1}", new Object[]{attributeInfo.namespace, attributeInfo.name});
        }
        this.attributeInfo.add(attributeInfo);
        this.attribute.add(genericType);
        genericType.setParent(this);
    }

    public int getAttributeCount() {
        return this.attribute.size();
    }

    public int getAttributeInfoCount() {
        return this.attributeInfo.size();
    }

    public Object getAttribute(int n) {
        Object var2_2 = null;
        if (n < 0 || n >= this.getAttributeCount()) {
            return null;
        }
        var2_2 = this.attribute.get(n);
        return var2_2;
    }

    public Object getAttribute(int n, String string) {
        return this.getAttribute(n);
    }

    public Object getAttribute(String string) {
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.name)) continue;
            return this.attribute.get(i);
        }
        return null;
    }

    public Object getAttribute(String string, String string2) {
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.namespace) || !string2.equalsIgnoreCase(attributeInfo.name)) continue;
            return this.attribute.get(i);
        }
        return null;
    }

    public Object getAttribute(String string, int n) {
        List list = this.getAttributeCollection(string);
        if (n < 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    public int getAttributeCount(String string, String string2) {
        int n = 0;
        if (string == null) {
            return this.getAttributeCount(string2);
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "getAttributeCount", "There were {0} {1} attributes with the name of {2}.", new Object[]{new Integer(n), new Integer(this.attributeInfo.size()), string2});
        }
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.namespace) || !string2.equalsIgnoreCase(attributeInfo.name)) continue;
            ++n;
        }
        return n;
    }

    public int getAttributeCount(String string) {
        int n = 0;
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.name)) continue;
            ++n;
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "getAttributeCount", "There were {0} {1} attributes with the name of {2}.", new Object[]{new Integer(n), new Integer(this.attributeInfo.size()), string});
        }
        return n;
    }

    public AttributeInfo getAttributeInfo(String string) {
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.name)) continue;
            return attributeInfo;
        }
        return null;
    }

    public AttributeInfo getAttributeInfo(String string, String string2) {
        if (string == null) {
            return this.getAttributeInfo(string2);
        }
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.namespace) || !string2.equalsIgnoreCase(attributeInfo.name)) continue;
            return attributeInfo;
        }
        return null;
    }

    public AttributeInfo getAttributeInfo(int n) {
        if (n < 0 || n >= this.getAttributeCount()) {
            return null;
        }
        return (AttributeInfo)((Object)this.attributeInfo.get(n));
    }

    public AttributeInfo getAttributeInfo(String string, int n) {
        List list = this.getAttributeInfoCollection(string);
        if (n < 0 || n > list.size()) {
            return null;
        }
        return (AttributeInfo)((Object)list.get(n));
    }

    public Class getAttributeType(String string) {
        AttributeInfo attributeInfo = this.getAttributeInfo(string);
        return (Class)(attributeInfo != null ? attributeInfo.type : null);
    }

    public boolean isUpdateable(String string) {
        return false;
    }

    public boolean isDeferred() {
        return false;
    }

    public boolean isModified() {
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            AttributeInfo attributeInfo = this.getAttributeInfo(i);
            if (!attributeInfo.modified) continue;
            return true;
        }
        return false;
    }

    public void setAttributeModified(String string) {
        AttributeInfo attributeInfo = this.getAttributeInfo(string);
        attributeInfo.modified = true;
        GenericType genericType = this.getParent();
        if (genericType != null) {
            attributeInfo = genericType.getAttributeInfo(this.name);
            if (attributeInfo == null) {
                for (int i = 0; i < genericType.getAttributeCount(); ++i) {
                    Object object = genericType.getAttribute(i);
                    if (!(object instanceof GenericType) || !this.name.equals(((GenericType)object).getName())) continue;
                    attributeInfo = genericType.getAttributeInfo(i);
                    break;
                }
                if (attributeInfo == null) {
                    return;
                }
            }
            if (!attributeInfo.modified) {
                genericType.setAttributeModified(attributeInfo.name);
            }
        }
    }

    public void restoreDefaults() {
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Object object;
            AttributeInfo attributeInfo = this.getAttributeInfo(i);
            attributeInfo.modified = false;
            if (attributeInfo.defaultValue != null) {
                this.setAttribute(i, attributeInfo.defaultValue);
            }
            if (!((object = this.getAttribute(i)) instanceof GenericType) || ((GenericType)object).isDeferred()) continue;
            ((GenericType)object).restoreDefaults();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.getClass().getName();
    }

    public Object getDataProvider() {
        return this;
    }

    public GenericType getParent() {
        return this.parent;
    }

    public boolean isComplexType() {
        return this.complex;
    }

    public void copy(GenericType genericType, boolean bl) {
        if (bl) {
            this.copy(genericType, false);
        } else {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "copy", "deep copy({0}, {1})", new Object[]{genericType.getNamespace(), genericType.getName()});
            }
            this.namespace = genericType.getNamespace();
            this.name = genericType.getName();
            this.attribute.clear();
            this.attributeInfo.clear();
            for (int i = 0; i < genericType.getAttributeCount(); ++i) {
                AttributeInfo attributeInfo = genericType.getAttributeInfo(i);
                Class clazz = null;
                if (attributeInfo.type instanceof Class) {
                    clazz = (Class)attributeInfo.type;
                }
                this.defineAttribute(attributeInfo.namespace, attributeInfo.name, clazz, genericType.getAttribute(i));
            }
        }
    }

    public GenericType copy() {
        GenericVirtualType genericVirtualType = new GenericVirtualType();
        genericVirtualType.copy(this, false);
        return genericVirtualType;
    }

    public void setAttribute(String string, Object object) {
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.name)) continue;
            if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "setAttribute", "Setting the {0}th attribute ({1}) to {2}", new Object[]{new Integer(i), string, object});
            }
            this.setAttributeValue(i, object);
        }
    }

    public void setAttribute(String string, String string2, Object object) {
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.namespace) || !string2.equalsIgnoreCase(attributeInfo.name)) continue;
            if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "setAttribute", "Setting the {0}th attribute ({1}) to {2}", new Object[]{new Integer(i), string2, object});
            }
            this.setAttributeValue(i, object);
        }
    }

    public void setAttribute(int n, Object object) {
        if (n < 0 || n >= this.getAttributeCount()) {
            return;
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "setAttribute", "Setting attribute #{0} of {1}.{2} to {3}", new Object[]{new Integer(n), this.namespace, this.name, object});
        }
        this.setAttributeValue(n, object);
    }

    public String toString() {
        String string = "";
        int n = this.getAttributeCount();
        if (n > 0 || this.complex) {
            string = "Generic Type: [" + this.namespace + ", " + this.name + "]";
        }
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            string = string + "\n  namespace = " + attributeInfo.namespace;
            string = string + "    name = " + attributeInfo.name;
            string = string + "    value = " + this.attribute.get(i);
        }
        return string;
    }

    public void setParent(GenericType genericType) {
        this.parent = genericType;
    }

    protected List getAttributeCollection(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.name)) continue;
            vector.add(this.attribute.get(i));
        }
        return vector;
    }

    protected List getAttributeInfoCollection(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.attributeInfo.size(); ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)this.attributeInfo.get(i));
            if (!string.equalsIgnoreCase(attributeInfo.name)) continue;
            vector.add(this.attributeInfo.get(i));
        }
        return vector;
    }

    protected void log(Level level, String string, String string2) {
        this.log(level, string, string2, null);
    }

    protected void log(Level level, String string, String string2, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, objectArray);
    }

    protected void log(Level level, String string, String string2, String string3, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, string3, objectArray);
    }

    private void setAttributeValue(int n, Object object) {
        Object object2;
        if (object instanceof GenericType) {
            object2 = (GenericType)object;
            object2.setParent(this);
            this.complex = true;
        }
        object2 = this.getAttributeInfo(n);
        this.setAttributeModified(((AttributeInfo)((Object)object2)).name);
        this.attribute.set(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insertChild(String string, int n, Object object) {
        GenericVirtualType genericVirtualType = this;
        synchronized (genericVirtualType) {
            int n2 = this.getAttributeCount(string);
            this.defineAttribute(null, string, null, object);
            int n3 = this.getAttributeCount(string);
            if (n3 > n2) {
                return object;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeChild(String string, int n) {
        GenericVirtualType genericVirtualType = this;
        synchronized (genericVirtualType) {
            List list = this.getAttributeCollection(string);
            int n2 = list.size();
            if (n >= 0 && n < n2) {
                Object e = list.get(n);
                int n3 = this.attribute.indexOf(e);
                this.attributeInfo.remove(n3);
                this.attribute.remove(n3);
                int n4 = this.getAttributeCount(string);
                if (n4 < n2) {
                    return e;
                }
            }
            return null;
        }
    }
}

