/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.metadata.bean.cache.SchemaAny;
import oracle.adfmf.util.Utility;

class XsdTypeInfo {
    private static final HashMap s_xsdTypeMap = new HashMap();
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private final String m_type;
    private final String m_javaType;
    private final boolean m_supportsPattern;
    private final boolean m_supportsLength;
    private final boolean m_supportsInclusive;
    private final boolean m_supportsDigits;
    private final Map m_defaults = new HashMap();

    private static XsdTypeInfo addXsdType(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        XsdTypeInfo xsdTypeInfo = new XsdTypeInfo(string, string2, bl, bl2, bl3, bl4);
        s_xsdTypeMap.put(string, xsdTypeInfo);
        return xsdTypeInfo;
    }

    private XsdTypeInfo(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.m_type = string;
        this.m_javaType = string2;
        this.m_supportsPattern = bl;
        this.m_supportsLength = bl2;
        this.m_supportsInclusive = bl3;
        this.m_supportsDigits = bl4;
    }

    protected static XsdTypeInfo get(SchemaAny schemaAny, String string) {
        String[] stringArray = XsdTypeInfo.breakupName(string);
        String string2 = stringArray[0];
        if (Utility.isEmpty(string2)) {
            return null;
        }
        String string3 = schemaAny.getNamespace(string2);
        if (Utility.isEmpty(string3)) {
            return null;
        }
        if (!SCHEMA_NS.equalsIgnoreCase(string3)) {
            return null;
        }
        return (XsdTypeInfo)s_xsdTypeMap.get(stringArray[1]);
    }

    protected String getType() {
        return this.m_type;
    }

    protected String getJavaType() {
        return this.m_javaType;
    }

    protected boolean supportsPattern() {
        return this.m_supportsPattern;
    }

    protected boolean supportsLength() {
        return this.m_supportsLength;
    }

    protected boolean supportsInclusive() {
        return this.m_supportsInclusive;
    }

    protected boolean supportsDigits() {
        return this.m_supportsDigits;
    }

    protected String getLocalName() {
        String[] stringArray = XsdTypeInfo.breakupName(this.m_type);
        return stringArray[1];
    }

    protected void addDefault(String string, String string2) {
        this.m_defaults.put(string, string2);
    }

    protected Map getDefaults() {
        return this.m_defaults;
    }

    protected static String[] breakupName(String string) {
        String[] stringArray = new String[2];
        stringArray[1] = string;
        int n = string.indexOf(58);
        if (n >= 0 && n + 1 < string.length()) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    static {
        XsdTypeInfo.addXsdType("anyURI", "java.lang.String", true, true, false, false);
        XsdTypeInfo.addXsdType("base64Binary", "java.lang.Object", true, true, false, false);
        XsdTypeInfo.addXsdType("boolean", "java.lang.Boolean", true, false, false, false);
        XsdTypeInfo xsdTypeInfo = XsdTypeInfo.addXsdType("byte", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "127");
        xsdTypeInfo.addDefault("minInclusive", "-128");
        XsdTypeInfo.addXsdType("date", "java.sql.Date", true, false, true, false);
        XsdTypeInfo.addXsdType("dateTime", "java.sql.Date", true, false, true, false);
        XsdTypeInfo.addXsdType("decimal", "java.math.BigDecimal", true, false, true, true);
        XsdTypeInfo.addXsdType("double", "java.lang.Double", true, false, true, false);
        XsdTypeInfo.addXsdType("duration", "java.lang.Object", true, false, true, false);
        XsdTypeInfo.addXsdType("float", "java.lang.Float", true, false, true, false);
        XsdTypeInfo.addXsdType("gDay", "java.lang.Object", true, false, true, false);
        XsdTypeInfo.addXsdType("gMonth", "java.lang.Object", true, false, true, false);
        XsdTypeInfo.addXsdType("gMonthDay", "java.lang.Object", true, false, true, false);
        XsdTypeInfo.addXsdType("gYear", "java.lang.Object", true, false, true, false);
        XsdTypeInfo.addXsdType("gYearMonth", "java.lang.Object", true, false, true, false);
        XsdTypeInfo.addXsdType("hexBinary", "java.lang.Byte[]", true, true, false, false);
        xsdTypeInfo = XsdTypeInfo.addXsdType("ID", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "[\\i-[:]][\\c-[:]]*");
        xsdTypeInfo = XsdTypeInfo.addXsdType("IDREF", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "[\\i-[:]][\\c-[:]]*");
        XsdTypeInfo.addXsdType("IDREFS", "java.lang.String", true, true, false, false);
        xsdTypeInfo = XsdTypeInfo.addXsdType("int", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "2147483647");
        xsdTypeInfo.addDefault("minInclusive", "-2147483648");
        xsdTypeInfo = XsdTypeInfo.addXsdType("integer", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo = XsdTypeInfo.addXsdType("language", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
        xsdTypeInfo = XsdTypeInfo.addXsdType("long", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "9223372036854775807");
        xsdTypeInfo.addDefault("minInclusive", "-9223372036854775808");
        xsdTypeInfo = XsdTypeInfo.addXsdType("Name", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "\\i\\c*");
        xsdTypeInfo = XsdTypeInfo.addXsdType("NCName", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "[\\i-[:]][\\c-[:]]*");
        xsdTypeInfo = XsdTypeInfo.addXsdType("negativeInteger", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "-1");
        xsdTypeInfo = XsdTypeInfo.addXsdType("NMTOKEN", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "\\c+");
        XsdTypeInfo.addXsdType("NMTOKENS", "java.lang.String", true, true, false, false);
        xsdTypeInfo = XsdTypeInfo.addXsdType("nonNegativeInteger", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("minInclusive", "0");
        xsdTypeInfo = XsdTypeInfo.addXsdType("nonPositiveInteger", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "0");
        xsdTypeInfo = XsdTypeInfo.addXsdType("normalizedString", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "replace");
        xsdTypeInfo.addDefault("pattern", "[^\\n\\t\\r]*");
        xsdTypeInfo = XsdTypeInfo.addXsdType("positiveInteger", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("minInclusive", "1");
        XsdTypeInfo.addXsdType("QName", "java.lang.Object", true, true, false, false);
        xsdTypeInfo = XsdTypeInfo.addXsdType("short", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "32767");
        xsdTypeInfo.addDefault("minInclusive", "-32768");
        XsdTypeInfo.addXsdType("string", "java.lang.String", true, true, false, false);
        XsdTypeInfo.addXsdType("time", "java.sql.Date", true, false, true, false);
        xsdTypeInfo = XsdTypeInfo.addXsdType("token", "java.lang.String", true, true, false, false);
        xsdTypeInfo.addDefault("whiteSpace", "collapse");
        xsdTypeInfo.addDefault("pattern", "([^ ]+( [^ ]+)*)?");
        xsdTypeInfo = XsdTypeInfo.addXsdType("unsignedByte", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "255");
        xsdTypeInfo.addDefault("minInclusive", "0");
        xsdTypeInfo = XsdTypeInfo.addXsdType("unsignedInt", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "4294967295");
        xsdTypeInfo.addDefault("minInclusive", "0");
        xsdTypeInfo = XsdTypeInfo.addXsdType("unsignedLong", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "18446744073709551615");
        xsdTypeInfo.addDefault("minInclusive", "0");
        xsdTypeInfo = XsdTypeInfo.addXsdType("unsignedShort", "java.math.BigDecimal", true, false, true, true);
        xsdTypeInfo.addDefault("fractionDigits", "0");
        xsdTypeInfo.addDefault("maxInclusive", "65535");
        xsdTypeInfo.addDefault("minInclusive", "0");
    }
}

