/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.adfmf.metadata.bean.transform.OperationMethod;
import oracle.adfmf.metadata.bean.transform.TransformUtil;
import oracle.adfmf.metadata.bean.transform.XmlAnyTransform;
import oracle.adfmf.metadata.dcx.DefinitionDefinition;
import oracle.adfmf.util.XmlAnyDefinition;

class OperationMethodTransform {
    protected final DefinitionDefinition m_defdef;
    protected final XmlAnyTransform m_trans;
    protected List m_methodList;
    protected HashSet m_methodSet;

    private OperationMethodTransform(XmlAnyTransform xmlAnyTransform, DefinitionDefinition definitionDefinition) {
        this.m_trans = xmlAnyTransform;
        this.m_defdef = definitionDefinition;
    }

    protected static OperationMethod[] buildMethodList(XmlAnyTransform xmlAnyTransform, DefinitionDefinition definitionDefinition) {
        return new OperationMethodTransform(xmlAnyTransform, definitionDefinition).buildMethodList();
    }

    private OperationMethod[] buildMethodList() {
        this.m_methodList = new ArrayList();
        this.m_methodSet = new HashSet();
        this.addMethodsFromService(this.m_defdef.getChildDefinition("service"));
        return this.m_methodList.toArray(new OperationMethod[0]);
    }

    private void addMethodsFromService(XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition == null) {
            return;
        }
        String string = TransformUtil.getAttributeValue(xmlAnyDefinition, "connection");
        if (!this.m_defdef.getName().equals(string)) {
            return;
        }
        List list = xmlAnyDefinition.getChildDefinitions("port");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addMethodsFromPort((XmlAnyDefinition)iterator.next());
        }
    }

    private void addMethodsFromPort(XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition == null) {
            return;
        }
        String string = TransformUtil.getAttributeValue(xmlAnyDefinition, "name");
        XmlAnyDefinition xmlAnyDefinition2 = this.m_trans.getServicePort(string);
        if (xmlAnyDefinition2 == null) {
            return;
        }
        List list = xmlAnyDefinition.getChildDefinitions("operation");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addMethodsFromOperation(string, (XmlAnyDefinition)iterator.next());
        }
    }

    private void addMethodsFromOperation(String string, XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition == null) {
            return;
        }
        String string2 = TransformUtil.getAttributeValue(xmlAnyDefinition, "name");
        if (this.m_methodSet.contains(string2)) {
            return;
        }
        this.m_methodSet.add(string2);
        this.m_methodList.add(new OperationMethod(string, string2));
    }
}

