/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.cache;

import com.sun.util.logging.Level;
import java.io.IOException;
import java.io.InputStream;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;
import oracle.ksoap2.transport.HttpServiceConnection;

class AnyCacheUtils {
    AnyCacheUtils() {
    }

    static XmlAnyDefinition resolveFile(String string, String string2) {
        string = string.replace('\\', '/');
        return XmlAnyDefinition.loadXmlFromLocation(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static XmlAnyDefinition resolveUrl(String string, String string2) {
        try {
            XmlAnyDefinition xmlAnyDefinition;
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AnyCacheUtils.class, "resolveUrl", "WebServices: attempting to retrieve external file {0}", new Object[]{string});
            }
            HttpServiceConnection httpServiceConnection = new HttpServiceConnection(string);
            InputStream inputStream = httpServiceConnection.openInputStream();
            try {
                xmlAnyDefinition = XmlAnyDefinition.loadXmlFromStream(string, inputStream, string2);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Utility.closeSilently(inputStream);
                throw throwable;
            }
            Utility.closeSilently(inputStream);
            return xmlAnyDefinition;
        }
        catch (IOException iOException) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                iOException.printStackTrace();
            }
            throw new AdfException(iOException);
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                exception.printStackTrace();
            }
            throw new AdfException(exception);
        }
    }

    static XmlAnyDefinition resolve(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (Utility.isUrlRemote(string)) {
            return AnyCacheUtils.resolveUrl(string, string2);
        }
        if (string.toLowerCase().startsWith("file://")) {
            string = string.substring(7);
        }
        return AnyCacheUtils.resolveFile(string, string2);
    }
}

