/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.openurl;

import java.util.LinkedList;
import java.util.ListIterator;
import oracle.adfmf.framework.event.Event;
import oracle.adfmf.framework.event.EventListener;
import oracle.adfmf.framework.event.EventSource;

public class OpenURLEventSource
extends EventSource {
    protected static boolean queueEvents;
    protected static LinkedList queue;

    public OpenURLEventSource() {
        super("OpenURL");
        queueEvents = false;
        queue = new LinkedList();
    }

    public void receivedOpenURLEvent(String string, boolean bl) {
        if (queueEvents) {
            QueueEntry queueEntry = new QueueEntry();
            queueEntry.url = string;
            queueEntry.launchEvent = bl;
            queue.add(queueEntry);
        } else {
            this.receivedOpenURLBroadcast(string, bl);
        }
    }

    protected synchronized void receivedOpenURLBroadcast(String string, boolean bl) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        Event event = new Event(this, string, bl);
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            EventListener eventListener = (EventListener)listIterator.next();
            eventListener.onMessage(event);
        }
    }

    public synchronized void enableBroadcast() {
        while (!queue.isEmpty()) {
            QueueEntry queueEntry = (QueueEntry)queue.removeFirst();
            this.receivedOpenURLBroadcast(queueEntry.url, queueEntry.launchEvent);
        }
        queueEvents = false;
    }

    public synchronized void disableBroadcast() {
        queueEvents = true;
    }

    class QueueEntry {
        String url;
        boolean launchEvent;

        QueueEntry() {
        }
    }
}

