/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.event.DataChangeManager;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.util.Utility;

public final class FrameworkPropertyChangeListener
implements PropertyChangeListener {
    private String scopeName = null;

    public FrameworkPropertyChangeListener(String string) {
        this.scopeName = string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DataChangeManager dataChangeManager = ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager();
        String string = propertyChangeEvent.getPropertyName();
        if (Utility.isNotEmpty(this.scopeName)) {
            string = this.scopeName + "." + propertyChangeEvent.getPropertyName();
        }
        dataChangeManager.enqueue(AdfmfJavaUtilities.getActiveContextId(), new PropertyChangeEvent(propertyChangeEvent.getSource(), string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getTimestamp()));
    }

    public static final void addFrameworkPropertyChangeListener(Object object, String string) {
        Method method = null;
        Class[] classArray = new Class[]{PropertyChangeListener.class};
        try {
            method = object.getClass().getMethod("addPropertyChangeListener", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        if (method == null) {
            return;
        }
        try {
            FrameworkPropertyChangeListener frameworkPropertyChangeListener = new FrameworkPropertyChangeListener(string);
            method.invoke(object, frameworkPropertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

