/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.event;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.ProviderChangeEvent;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class DataChangeEvent
implements JSONSerializable {
    public static final boolean ENABLE_DCE_LOGGING = false;
    private List providerChanges = new ArrayList();
    private List propertyChanges = new ArrayList();

    public synchronized int getPropertyChangeCount() {
        return this.propertyChanges != null ? this.propertyChanges.size() : 0;
    }

    public synchronized int getProviderChangeCount() {
        return this.providerChanges != null ? this.providerChanges.size() : 0;
    }

    public synchronized void enqueue(ProviderChangeEvent providerChangeEvent) {
        List list = this.providerChanges;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            ProviderChangeEvent providerChangeEvent2 = null;
            providerChangeEvent2 = (ProviderChangeEvent)list.get(i);
            if (!providerChangeEvent2.getOperation().equals("update") || !providerChangeEvent2.getProviderKey().equals(providerChangeEvent.getProviderKey()) || !providerChangeEvent2.getCurrentRowKey().equals(providerChangeEvent.getCurrentRowKey())) continue;
            if (providerChangeEvent2.getTimestamp() < providerChangeEvent.getTimestamp()) {
                list.set(i, providerChangeEvent);
                bl = true;
                continue;
            }
            if (providerChangeEvent2.getTimestamp() != providerChangeEvent.getTimestamp() || providerChangeEvent2.getNewValue() == null || providerChangeEvent2.getNewValue().equals(providerChangeEvent.getNewValue())) continue;
            list.set(i, new ProviderChangeEvent("dirty", providerChangeEvent.getProviderKey(), providerChangeEvent.getCurrentRowKey(), providerChangeEvent.getNewValue()));
            if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) continue;
            Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "enqueue", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40115");
        }
        if (!bl) {
            list.add(providerChangeEvent);
        }
    }

    public synchronized void enqueue(PropertyChangeEvent propertyChangeEvent) {
        List list = this.propertyChanges;
        boolean bl = false;
        for (int i = 0; !bl && i < list.size(); ++i) {
            PropertyChangeEvent propertyChangeEvent2 = null;
            propertyChangeEvent2 = (PropertyChangeEvent)list.get(i);
            if (!propertyChangeEvent2.getPropertyName().equals(propertyChangeEvent.getPropertyName())) continue;
            if (propertyChangeEvent2.getTimestamp() < propertyChangeEvent.getTimestamp()) {
                list.set(i, propertyChangeEvent);
            } else if (propertyChangeEvent2.getTimestamp() == propertyChangeEvent.getTimestamp() && propertyChangeEvent2.getNewValue() != null && !propertyChangeEvent2.getNewValue().equals(propertyChangeEvent.getNewValue())) {
                Object object = null;
                PropertyChangeEvent propertyChangeEvent3 = null;
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "enqueue", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40115");
                }
                object = AdfmfJavaUtilities.evaluateELExpression("#{" + propertyChangeEvent.getPropertyName() + "}");
                propertyChangeEvent3 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), object);
                list.set(i, propertyChangeEvent3);
            }
            bl = true;
        }
        if (!bl) {
            list.add(propertyChangeEvent);
        }
    }

    public synchronized void enqueue(Object object) {
        if (object instanceof PropertyChangeEvent) {
            this.enqueue((PropertyChangeEvent)object);
        } else if (object instanceof ProviderChangeEvent) {
            this.enqueue((ProviderChangeEvent)object);
        } else {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11123"));
        }
    }

    private ProviderChangeEvent findMatchingCreate(ProviderChangeEvent providerChangeEvent) {
        int n = this.providerChanges.indexOf(providerChangeEvent);
        while (--n >= 0) {
            ProviderChangeEvent providerChangeEvent2 = (ProviderChangeEvent)this.providerChanges.get(n);
            if (!"create".equals(providerChangeEvent2.getOperation()) || !providerChangeEvent2.getCurrentRowKey().equals(providerChangeEvent.getCurrentRowKey())) continue;
            return providerChangeEvent2;
        }
        return null;
    }

    private Object nullCheckValue(Object hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
            ((Map)hashMap).put(".null", new Boolean(true));
        }
        return hashMap;
    }

    private void updateProviderEventRowEntry(Map map, ProviderChangeEvent providerChangeEvent) throws Exception {
        if (map.containsKey(providerChangeEvent.getOperation())) {
            Map map2 = (Map)map.get(providerChangeEvent.getOperation());
            if (providerChangeEvent.getCurrentRowKey() != null) {
                map2.put(providerChangeEvent.getCurrentRowKey(), this.nullCheckValue(providerChangeEvent.getNewValue()));
            } else {
                map2.put(providerChangeEvent.getColumnAttribute(), this.nullCheckValue(providerChangeEvent.getNewValue()));
            }
        } else {
            map.put(providerChangeEvent.getOperation(), new HashMap());
            this.updateProviderEventRowEntry(map, providerChangeEvent);
        }
    }

    private void updateProviderEventEntry(Map map, ProviderChangeEvent providerChangeEvent) throws Exception {
        Map map2 = (Map)map.get(providerChangeEvent.getProviderKey());
        if (providerChangeEvent.getCurrentRowKey() != null) {
            if (map2.containsKey("providers")) {
                this.updateProviderEventRowEntry((Map)map2.get("providers"), providerChangeEvent);
            } else {
                map2.put("providers", new HashMap());
                this.updateProviderEventEntry(map, providerChangeEvent);
            }
        } else if (map2.containsKey("columnAttributes")) {
            this.updateProviderEventRowEntry((Map)map2.get("columnAttributes"), providerChangeEvent);
        } else {
            map2.put("columnAttributes", new HashMap());
            this.updateProviderEventEntry(map, providerChangeEvent);
        }
    }

    public Object toJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        try {
            Object object;
            Object object2;
            Object object3;
            Collections.sort(this.providerChanges);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Object object4 = this.providerChanges.iterator();
            while (object4.hasNext()) {
                object3 = (ProviderChangeEvent)object4.next();
                if ("remove".equals(((ProviderChangeEvent)object3).getOperation()) && (object2 = this.findMatchingCreate((ProviderChangeEvent)object3)) != null) {
                    object = (Map)hashMap.get(((ProviderChangeEvent)object3).getProviderKey());
                    Map map = (Map)object.get("providers");
                    Map map2 = (Map)map.get(((ProviderChangeEvent)object2).getOperation());
                    map2.remove(((ProviderChangeEvent)object2).getCurrentRowKey());
                    continue;
                }
                if (hashMap.containsKey(((ProviderChangeEvent)object3).getProviderKey())) {
                    this.updateProviderEventEntry(hashMap, (ProviderChangeEvent)object3);
                    continue;
                }
                object2 = new HashMap();
                hashMap.put(((ProviderChangeEvent)object3).getProviderKey(), object2);
                this.updateProviderEventEntry(hashMap, (ProviderChangeEvent)object3);
            }
            jSONObject.put("providerChanges", JSONBeanSerializationHelper.toJSON(hashMap));
            Collections.sort(this.propertyChanges);
            object4 = new HashMap();
            object3 = this.propertyChanges.iterator();
            while (object3.hasNext()) {
                object2 = (PropertyChangeEvent)object3.next();
                object = this.nullCheckValue(((PropertyChangeEvent)object2).getNewValue());
                object4.put(((PropertyChangeEvent)object2).getPropertyName(), object);
            }
            jSONObject.put("variableChanges", JSONBeanSerializationHelper.toJSON(object4));
        }
        catch (AdfException adfException) {
            throw adfException;
        }
        catch (JSONException jSONException) {
            throw new AdfException(jSONException, "ERROR");
        }
        catch (Exception exception) {
            throw new AdfException(exception, "ERROR");
        }
        return jSONObject;
    }

    protected void merge(DataChangeEvent dataChangeEvent) {
        Comparable comparable;
        if (dataChangeEvent == this) {
            return;
        }
        Iterator iterator = dataChangeEvent.propertyChanges.iterator();
        while (iterator.hasNext()) {
            comparable = (PropertyChangeEvent)iterator.next();
            this.propertyChanges.add(comparable);
        }
        dataChangeEvent.propertyChanges.clear();
        iterator = dataChangeEvent.providerChanges.iterator();
        while (iterator.hasNext()) {
            comparable = (ProviderChangeEvent)iterator.next();
            this.providerChanges.add(comparable);
        }
        dataChangeEvent.providerChanges.clear();
    }
}

