/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.contract.adf.application;

import com.sun.util.logging.Level;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.adfmf.framework.FeatureContextAccessor;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.contract.adf.application.GenericInvokeRequest;
import oracle.adfmf.framework.contract.adf.application.GenericInvokeResponse;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.message.adf.AdfRequestHandler;
import oracle.adfmf.framework.message.adf.AdfResponse;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.performance.Monitor;
import oracle.adfmf.performance.MonitorFactory;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public abstract class GenericInvokeRequestHandler
implements AdfRequestHandler {
    protected GenericInvokeRequest request = null;

    public GenericInvokeRequestHandler(GenericInvokeRequest genericInvokeRequest) {
        this.request = genericInvokeRequest;
    }

    private String getRequestMessage() {
        StringBuffer stringBuffer = new StringBuffer("Request message:");
        stringBuffer.append(this.request.getBody().toString());
        int n = stringBuffer.indexOf("\"", 0);
        while (n >= 0) {
            stringBuffer.insert(n++, "\\");
            ++n;
            n = stringBuffer.indexOf("\"", n);
        }
        return stringBuffer.toString();
    }

    protected static AdfException getOrCreateAdfException(String string, String string2, Throwable throwable) {
        AdfException adfException = Utility.findAdfException(throwable);
        if (adfException == null) {
            adfException = new AdfException(string, string2);
        }
        return adfException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdfResponse process(FeatureContextAccessor featureContextAccessor) throws AdfException {
        GenericInvokeResponse genericInvokeResponse;
        block7: {
            MonitorFactory monitorFactory = MonitorFactory.getInstance();
            genericInvokeResponse = (GenericInvokeResponse)this.request.createResponse();
            Monitor monitor = monitorFactory.getMonitor(this.getClass().getName() + ":process.all", "monitoring generic requests processing time");
            Monitor monitor2 = monitorFactory.getMonitor(this.getClass().getName() + ":process.invoke", "monitoring generic requests invoke processing time");
            Monitor monitor3 = monitorFactory.getMonitor(this.getClass().getName() + ":process.serialize", "monitoring generic requests serialize processing time");
            Object object = null;
            monitor.start();
            try {
                try {
                    Object object2 = null;
                    monitor2.start();
                    String string = this.request.getClassname();
                    object = this.invoke(string, this.request.getMethod(), this.request.getParameters());
                    monitor2.addObservation();
                    monitor3.start();
                    object2 = JSONBeanSerializationHelper.toJSON(object);
                    monitor3.addObservation();
                    genericInvokeResponse.setResult(object2);
                    genericInvokeResponse.setResponseReady(true);
                }
                catch (AdfException adfException) {
                    if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, GenericInvokeRequestHandler.class, "process", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10007", new Object[]{adfException});
                    }
                    genericInvokeResponse.setException(adfException);
                    Object var11_14 = null;
                    this.processFinally(featureContextAccessor, genericInvokeResponse);
                    monitor.addObservation();
                    break block7;
                }
                catch (Throwable throwable) {
                    if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, GenericInvokeRequestHandler.class, "process", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10008", new Object[]{throwable});
                    }
                    AdfException adfException = GenericInvokeRequestHandler.getOrCreateAdfException(throwable.getMessage(), "ERROR", throwable);
                    genericInvokeResponse.setException(adfException);
                    Object var11_15 = null;
                    this.processFinally(featureContextAccessor, genericInvokeResponse);
                    monitor.addObservation();
                }
                Object var11_13 = null;
                this.processFinally(featureContextAccessor, genericInvokeResponse);
                monitor.addObservation();
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                this.processFinally(featureContextAccessor, genericInvokeResponse);
                monitor.addObservation();
                throw throwable;
            }
        }
        return genericInvokeResponse;
    }

    protected Object invoke(String string, String string2, JSONArray jSONArray) throws Throwable {
        Class clazz = null;
        try {
            clazz = Utility.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10001", new Object[]{classNotFoundException.getMessage()});
        }
        Method[] methodArray = clazz.getMethods();
        Object object = null;
        boolean bl = false;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, GenericInvokeRequestHandler.class, "invoke", "GenericInvokeRequestHandler.invoke({0}, {1}, ...)", new Object[]{string, string2});
        }
        for (int i = 0; !bl && i < methodArray.length; ++i) {
            if (!string2.equals(methodArray[i].getName()) || methodArray[i].getParameterTypes().length != jSONArray.length()) continue;
            try {
                bl = true;
                object = this.invoke(clazz, methodArray[i], jSONArray);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler == null ? GenericInvokeRequestHandler.class$("oracle.adfmf.framework.contract.adf.application.GenericInvokeRequestHandler") : class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10009", new Object[]{"IllegalArgumentException", illegalArgumentException});
                }
                bl = false;
                continue;
            }
            catch (InstantiationException instantiationException) {
                if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                    Trace.log(Utility.FrameworkLogger, Level.SEVERE, class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler == null ? GenericInvokeRequestHandler.class$("oracle.adfmf.framework.contract.adf.application.GenericInvokeRequestHandler") : class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10009", new Object[]{"InstantiationException", instantiationException});
                }
                bl = false;
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                    Trace.log(Utility.FrameworkLogger, Level.SEVERE, GenericInvokeRequestHandler.class, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10009", new Object[]{"InvocationTargetException", invocationTargetException.getTargetException()});
                }
                throw invocationTargetException.getTargetException();
            }
        }
        if (!bl) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, GenericInvokeRequestHandler.class, "invoke", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10004", new Object[]{string, string2});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10003", new Object[]{string2});
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, GenericInvokeRequestHandler.class, "invoke", "GenericInvokeRequestHandler.invoke({0}, {1}, ...) is returning [{2}]", new Object[]{string, string2, object});
        }
        return object;
    }

    protected boolean getBoolean(Object object) throws Exception {
        return object instanceof Boolean ? (Boolean)object : Boolean.getBoolean((String)object);
    }

    protected byte getByte(Object object) {
        return object instanceof Number ? ((Number)object).byteValue() : Byte.parseByte((String)object);
    }

    protected double getDouble(Object object) {
        return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
    }

    protected float getFloat(Object object) {
        return object instanceof Number ? ((Number)object).floatValue() : Float.parseFloat((String)object);
    }

    protected int getInteger(Object object) {
        return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
    }

    protected long getLong(Object object) {
        return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
    }

    protected short getShort(Object object) {
        return object instanceof Number ? ((Number)object).shortValue() : Short.parseShort((String)object);
    }

    protected String getString(Object object) {
        return (String)object;
    }

    protected Object invoke(Class clazz, Method method, JSONArray jSONArray) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            try {
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler == null ? GenericInvokeRequestHandler.class$("oracle.adfmf.framework.contract.adf.application.GenericInvokeRequestHandler") : class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler, "invoke", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40003", new Object[]{classArray[i], jSONArray.get(i)});
                }
                objectArray[i] = JSONBeanSerializationHelper.fromJSON(classArray[i], jSONArray.get(i));
                continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10010", new Object[]{new Integer(i)}));
            }
        }
        Object t = clazz.newInstance();
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, GenericInvokeRequestHandler.class, "invoke", "Invoking the method : {0}", new Object[]{method.getName()});
        }
        return method.invoke(t, objectArray);
    }

    protected void printClassInformation(String string) throws Exception {
        Class clazz = Utility.loadClass(string);
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler == null ? GenericInvokeRequestHandler.class$("oracle.adfmf.framework.contract.adf.application.GenericInvokeRequestHandler") : class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler, "printClassInformation", "Method: {0}", new Object[]{methodArray[i].getName()});
            }
            for (int j = 0; j < classArray.length; ++j) {
                if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) continue;
                Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler == null ? GenericInvokeRequestHandler.class$("oracle.adfmf.framework.contract.adf.application.GenericInvokeRequestHandler") : class$oracle$adfmf$framework$contract$adf$application$GenericInvokeRequestHandler, "printClassInformation", "     ", new Object[]{classArray[j].getName()});
            }
        }
    }

    abstract void processFinally(FeatureContextAccessor var1, GenericInvokeResponse var2);
}

